/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class Backup
implements Runnable {
    private final transient Server server;
    private final transient IEssentials ess;
    private final AtomicBoolean pendingShutdown = new AtomicBoolean(false);
    private transient boolean running = false;
    private transient int taskId = -1;
    private transient boolean active = false;
    private transient CompletableFuture<Object> taskLock = null;

    public Backup(IEssentials ess) {
        this.ess = ess;
        this.server = ess.getServer();
        if (!ess.getOnlinePlayers().isEmpty() || ess.getSettings().isAlwaysRunBackup()) {
            ess.runTaskAsynchronously(this::startTask);
        }
    }

    public void onPlayerJoin() {
        this.startTask();
    }

    public synchronized void stopTask() {
        this.running = false;
        if (this.taskId != -1) {
            this.server.getScheduler().cancelTask(this.taskId);
        }
        this.taskId = -1;
    }

    private synchronized void startTask() {
        if (!this.running) {
            long interval = this.ess.getSettings().getBackupInterval() * 1200L;
            if (interval < 1200L) {
                return;
            }
            this.taskId = this.ess.scheduleSyncRepeatingTask(this, interval, interval);
            this.running = true;
        }
    }

    public CompletableFuture<Object> getTaskLock() {
        return this.taskLock;
    }

    public void setPendingShutdown(boolean shutdown) {
        this.pendingShutdown.set(shutdown);
    }

    @Override
    public void run() {
        if (this.active) {
            return;
        }
        String command = this.ess.getSettings().getBackupCommand();
        if (command == null || "".equals(command)) {
            return;
        }
        this.active = true;
        this.taskLock = new CompletableFuture();
        if ("save-all".equalsIgnoreCase(command)) {
            ConsoleCommandSender cs = this.server.getConsoleSender();
            this.server.dispatchCommand((CommandSender)cs, "save-all");
            this.active = false;
            this.taskLock.complete(new Object());
            return;
        }
        this.ess.getLogger().log(Level.INFO, I18n.tl("backupStarted", new Object[0]));
        ConsoleCommandSender cs = this.server.getConsoleSender();
        this.server.dispatchCommand((CommandSender)cs, "save-all");
        this.server.dispatchCommand((CommandSender)cs, "save-off");
        this.ess.runTaskAsynchronously(() -> this.lambda$run$1(command, (CommandSender)cs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$run$1(String command, CommandSender cs) {
        try {
            ProcessBuilder childBuilder = new ProcessBuilder(command.split(" "));
            childBuilder.redirectErrorStream(true);
            childBuilder.directory(this.ess.getDataFolder().getParentFile().getParentFile());
            Process child = childBuilder.start();
            this.ess.runTaskAsynchronously(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(child.getInputStream()));){
                    String line;
                    do {
                        if ((line = reader.readLine()) == null) continue;
                        this.ess.getLogger().log(Level.INFO, line);
                    } while (line != null);
                }
                catch (IOException ex) {
                    this.ess.getLogger().log(Level.SEVERE, "An error occurred while reading backup child process", ex);
                }
            });
            child.waitFor();
        }
        catch (IOException | InterruptedException ex) {
            this.ess.getLogger().log(Level.SEVERE, "An error occurred while building the backup child process", ex);
        }
        finally {
            if (!this.pendingShutdown.get()) {
                class BackupEnableSaveTask
                implements Runnable {
                    final /* synthetic */ CommandSender val$cs;

                    BackupEnableSaveTask() {
                        this.val$cs = commandSender;
                    }

                    @Override
                    public void run() {
                        Backup.this.server.dispatchCommand(this.val$cs, "save-on");
                        if (!Backup.this.ess.getSettings().isAlwaysRunBackup() && Backup.this.ess.getOnlinePlayers().isEmpty()) {
                            Backup.this.stopTask();
                        }
                        Backup.this.active = false;
                        Backup.this.taskLock.complete(new Object());
                        Backup.this.ess.getLogger().log(Level.INFO, I18n.tl("backupFinished", new Object[0]));
                    }
                }
                this.ess.scheduleSyncDelayedTask(new BackupEnableSaveTask());
            }
        }
    }
}

