/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.FakeWorld;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Kits;
import com.earth2me.essentials.ManagedFile;
import com.earth2me.essentials.User;
import com.earth2me.essentials.config.ConfigurateUtil;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.config.EssentialsUserConfiguration;
import com.earth2me.essentials.craftbukkit.BanLookup;
import com.earth2me.essentials.libs.configurate.CommentedConfigurationNode;
import com.earth2me.essentials.userstorage.ModernUUIDCache;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import net.essentialsx.api.v2.services.mail.MailMessage;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class EssentialsUpgrade {
    public static final FileFilter YML_FILTER = pathname -> pathname.isFile() && pathname.getName().endsWith(".yml");
    private static final String PATTERN_CONFIG_UUID_REGEX = "(?mi)^uuid:\\s*([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})\\s*$";
    private static final Pattern PATTERN_CONFIG_UUID = Pattern.compile("(?mi)^uuid:\\s*([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})\\s*$");
    private static final String PATTERN_CONFIG_NAME_REGEX = "(?mi)^lastAccountName:\\s*[\"']?(\\w+)[\"']?\\s*$";
    private static final Pattern PATTERN_CONFIG_NAME = Pattern.compile("(?mi)^lastAccountName:\\s*[\"']?(\\w+)[\"']?\\s*$");
    private final transient IEssentials ess;
    private final transient EssentialsConfiguration doneFile;

    EssentialsUpgrade(IEssentials essentials) {
        this.ess = essentials;
        if (!this.ess.getDataFolder().exists()) {
            this.ess.getDataFolder().mkdirs();
        }
        this.doneFile = new EssentialsConfiguration(new File(this.ess.getDataFolder(), "upgrades-done.yml"));
        this.doneFile.load();
    }

    public static void uuidFileConvert(IEssentials ess, Boolean ignoreUFCache) {
        ess.getLogger().info("Starting Essentials UUID userdata conversion");
        File userdir = new File(ess.getDataFolder(), "userdata");
        if (!userdir.exists()) {
            return;
        }
        int countFiles = 0;
        int countFails = 0;
        int countEssCache = 0;
        int countBukkit = 0;
        ess.getLogger().info("Found " + userdir.list().length + " files to convert...");
        for (String string : userdir.list()) {
            if (!string.endsWith(".yml") || string.length() < 5) continue;
            int showProgress = countFiles % 250;
            if (showProgress == 0) {
                ess.getLogger().info("Converted " + countFiles + "/" + userdir.list().length);
            }
            ++countFiles;
            String name = string.substring(0, string.length() - 4);
            UUID uuid = null;
            try {
                UUID.fromString(name);
            }
            catch (IllegalArgumentException ex) {
                File file = new File(userdir, string);
                EssentialsConfiguration conf = new EssentialsConfiguration(file);
                conf.load();
                conf.setProperty("lastAccountName", name);
                conf.save();
                String uuidConf = ignoreUFCache != false ? "force-uuid" : "uuid";
                String uuidString = conf.getString(uuidConf, null);
                for (int i = 0; i < 4; ++i) {
                    try {
                        uuid = UUID.fromString(uuidString);
                        ++countEssCache;
                        break;
                    }
                    catch (Exception ex2) {
                        if (conf.getBoolean("npc", false)) {
                            uuid = UUID.nameUUIDFromBytes(("NPC:" + (ess.getSettings().isSafeUsermap() ? StringUtil.safeString(name) : name)).getBytes(Charsets.UTF_8));
                            break;
                        }
                        OfflinePlayer player = ess.getServer().getOfflinePlayer(name);
                        uuid = player.getUniqueId();
                        if (uuid == null) continue;
                        ++countBukkit;
                        break;
                    }
                }
                if (uuid != null) {
                    conf.blockingSave();
                    EssentialsUserConfiguration config = new EssentialsUserConfiguration(name, uuid, new File(userdir, uuid + ".yml"));
                    config.convertLegacyFile();
                    ess.getUsers().loadUncachedUser(uuid);
                    continue;
                }
                ++countFails;
            }
        }
        ess.getLogger().info("Converted " + countFiles + "/" + countFiles + ".  Conversion complete.");
        ess.getLogger().info("Converted via cache: " + countEssCache + " :: Converted via lookup: " + countBukkit + " :: Failed to convert: " + countFails);
        ess.getLogger().info("To rerun the conversion type /essentials uuidconvert");
    }

    public void convertMailList() {
        File[] userFiles;
        if (this.doneFile.getBoolean("updateUsersMailList", false)) {
            return;
        }
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConfiguration config = new EssentialsConfiguration(file);
            try {
                config.load();
                if (!config.hasProperty("mail") || !config.isList("mail")) continue;
                ArrayList<MailMessage> messages = new ArrayList<MailMessage>();
                for (String mailStr : Collections.synchronizedList(config.getList("mail", String.class))) {
                    if (mailStr == null) continue;
                    messages.add(new MailMessage(false, true, null, null, 0L, 0L, mailStr));
                }
                config.removeProperty("mail");
                config.setExplicitList("mail", messages, new TypeToken<List<MailMessage>>(){}.getType());
                config.blockingSave();
            }
            catch (RuntimeException ex) {
                this.ess.getLogger().log(Level.INFO, "File: " + file);
                throw ex;
            }
        }
        this.doneFile.setProperty("updateUsersMailList", true);
        this.doneFile.save();
        this.ess.getLogger().info("Done converting mail list.");
    }

    public void convertStupidCamelCaseUserdataKeys() {
        File[] userFiles;
        if (this.doneFile.getBoolean("updateUsersStupidLegacyPathNames", false)) {
            return;
        }
        this.ess.getLogger().info("Attempting to migrate legacy userdata keys to Configurate");
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConfiguration config = new EssentialsConfiguration(file);
            try {
                config.load();
                if (config.hasProperty("muteReason")) {
                    String reason = config.getString("muteReason", null);
                    config.removeProperty("muteReason");
                    config.setProperty("mute-reason", reason);
                }
                if (config.hasProperty("ipAddress")) {
                    String ip = config.getString("ipAddress", null);
                    config.removeProperty("ipAddress");
                    config.setProperty("ip-address", ip);
                }
                if (config.hasProperty("lastAccountName")) {
                    String name = config.getString("lastAccountName", null);
                    config.removeProperty("lastAccountName");
                    config.setProperty("last-account-name", name);
                }
                if (config.hasProperty("acceptingPay")) {
                    boolean isPay = config.getBoolean("acceptingPay", true);
                    config.removeProperty("acceptingPay");
                    config.setProperty("accepting-pay", isPay);
                }
                config.blockingSave();
            }
            catch (RuntimeException ex) {
                this.ess.getLogger().log(Level.INFO, "File: " + file);
                throw ex;
            }
        }
        this.doneFile.setProperty("updateUsersStupidLegacyPathNames", true);
        this.doneFile.save();
        this.ess.getLogger().info("Done converting legacy userdata keys to Configurate.");
    }

    public void purgeBrokenNpcAccounts() {
        if (this.doneFile.getBoolean("updatePurgeBrokenNpcAccounts", false)) {
            return;
        }
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        File[] userFiles = userdataFolder.listFiles();
        if (userFiles.length == 0) {
            return;
        }
        File backupFolder = new File(this.ess.getDataFolder(), "userdata-npc-backup");
        if (backupFolder.exists()) {
            this.ess.getLogger().info("NPC backup folder already exists; skipping NPC purge.");
            this.ess.getLogger().info("To finish purging broken NPC accounts, rename the \"plugins/Essentials/userdata-npc-backup\" folder and restart your server.");
            return;
        }
        if (!backupFolder.mkdir()) {
            this.ess.getLogger().info("Skipping NPC purge due to error creating backup folder.");
            return;
        }
        this.ess.getLogger().info("#===========================================================================#");
        this.ess.getLogger().info(" EssentialsX will now purge any NPC accounts which were incorrectly created.");
        this.ess.getLogger().info(" Only NPC accounts with the default starting balance will be deleted. If");
        this.ess.getLogger().info(" they turn out to be valid NPC accounts, they will be re-created as needed.");
        this.ess.getLogger().info(" Any files deleted here will be backed up to the ");
        this.ess.getLogger().info(" \"plugins/Essentials/userdata-npc-backup\" folder. If you notice any files");
        this.ess.getLogger().info(" have been purged incorrectly, you should restore it from the backup and");
        this.ess.getLogger().info(" report it to us on GitHub:");
        this.ess.getLogger().info(" https://github.com/EssentialsX/Essentials/issues/new/choose");
        this.ess.getLogger().info("");
        this.ess.getLogger().info(" NOTE: This is a one-time process and will take several minutes if you have");
        this.ess.getLogger().info(" a lot of userdata files! If you interrupt this process, EssentialsX will");
        this.ess.getLogger().info(" skip the process until you rename or remove the backup folder.");
        this.ess.getLogger().info("#===========================================================================#");
        int totalUserFiles = userFiles.length;
        this.ess.getLogger().info("Found ~" + totalUserFiles + " files under \"plugins/Essentials/userdata\"...");
        AtomicInteger movedAccounts = new AtomicInteger(0);
        AtomicInteger totalAccounts = new AtomicInteger(0);
        long feedbackInterval = Math.min(15L, 1L + Math.round(2.1 * Math.log10(userFiles.length)));
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> feedbackTask = executor.scheduleWithFixedDelay(() -> this.ess.getLogger().info("Scanned " + totalAccounts.get() + "/" + totalUserFiles + " accounts; moved " + movedAccounts.get() + " accounts"), 5L, feedbackInterval, TimeUnit.SECONDS);
        for (File file : userFiles) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConfiguration config = new EssentialsConfiguration(file);
            try {
                BigDecimal money;
                totalAccounts.incrementAndGet();
                config.load();
                if (config.getKeys().size() > 4 || !config.getBoolean("npc", false) || (money = config.getBigDecimal("money", null)) == null || money.compareTo(this.ess.getSettings().getStartingBalance()) != 0 || config.getKeys().size() == 4 && !config.hasProperty("last-account-name") && config.hasProperty("mail")) continue;
                try {
                    Files.move((File)file, (File)new File(backupFolder, file.getName()));
                    movedAccounts.incrementAndGet();
                }
                catch (IOException e) {
                    this.ess.getLogger().log(Level.SEVERE, "Error while moving NPC file", e);
                }
            }
            catch (RuntimeException ex) {
                this.ess.getLogger().log(Level.INFO, "File: " + file);
                feedbackTask.cancel(false);
                executor.shutdown();
                throw ex;
            }
        }
        feedbackTask.cancel(false);
        executor.shutdown();
        this.doneFile.setProperty("updatePurgeBrokenNpcAccounts", true);
        this.doneFile.save();
        this.ess.getLogger().info("#===========================================================================#");
        this.ess.getLogger().info(" EssentialsX has finished purging NPC accounts.");
        this.ess.getLogger().info("");
        this.ess.getLogger().info(" Deleted accounts: " + movedAccounts);
        this.ess.getLogger().info(" Total accounts processed: " + totalAccounts);
        this.ess.getLogger().info("");
        this.ess.getLogger().info(" Purged accounts have been backed up to");
        this.ess.getLogger().info(" \"plugins/Essentials/userdata-npc-backup\", and can be restored from there");
        this.ess.getLogger().info(" if needed. Please report any files which have been incorrectly deleted");
        this.ess.getLogger().info(" to us on GitHub:");
        this.ess.getLogger().info(" https://github.com/EssentialsX/Essentials/issues/new/choose");
        this.ess.getLogger().info("#===========================================================================#");
    }

    public void convertIgnoreList() {
        File[] userFiles;
        Pattern pattern = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
        if (this.doneFile.getBoolean("updateUsersIgnoreListUUID", false)) {
            return;
        }
        this.ess.getLogger().info("Attempting to migrate ignore list to UUIDs");
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConfiguration config = new EssentialsConfiguration(file);
            try {
                config.load();
                if (!config.hasProperty("ignore")) continue;
                ArrayList<String> migratedIgnores = new ArrayList<String>();
                for (String name : Collections.synchronizedList(config.getList("ignore", String.class))) {
                    if (name == null) continue;
                    if (pattern.matcher(name.trim()).matches()) {
                        this.ess.getLogger().info("Detected already migrated ignore list!");
                        return;
                    }
                    User user = this.ess.getOfflineUser(name);
                    if (user == null || user.getBase() == null) continue;
                    migratedIgnores.add(user.getBase().getUniqueId().toString());
                }
                config.removeProperty("ignore");
                config.setProperty("ignore", migratedIgnores);
                config.blockingSave();
            }
            catch (RuntimeException ex) {
                this.ess.getLogger().log(Level.INFO, "File: " + file);
                throw ex;
            }
        }
        this.doneFile.setProperty("updateUsersIgnoreListUUID", true);
        this.doneFile.save();
        this.ess.getLogger().info("Done converting ignore list.");
    }

    public void convertKits() {
        Kits kits = this.ess.getKits();
        EssentialsConfiguration config = kits.getRootConfig();
        if (this.doneFile.getBoolean("kitsyml", false)) {
            return;
        }
        this.ess.getLogger().info("Attempting to convert old kits in config.yml to new kits.yml");
        CommentedConfigurationNode section = this.ess.getSettings().getKitSection();
        if (section == null) {
            this.ess.getLogger().info("No kits found to migrate.");
            return;
        }
        Map<String, Object> legacyKits = ConfigurateUtil.getRawMap(section);
        for (Map.Entry<String, Object> entry : legacyKits.entrySet()) {
            this.ess.getLogger().info("Converting " + entry.getKey());
            config.setRaw("kits." + entry.getKey(), entry.getValue());
        }
        config.save();
        this.doneFile.setProperty("kitsyml", true);
        this.doneFile.save();
        this.ess.getLogger().info("Done converting kits.");
    }

    private void moveMotdRulesToFile(String name) {
        if (this.doneFile.getBoolean("move" + name + "ToFile", false)) {
            return;
        }
        try {
            File file = new File(this.ess.getDataFolder(), name + ".txt");
            if (file.exists()) {
                return;
            }
            File configFile = new File(this.ess.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                return;
            }
            EssentialsConfiguration conf = new EssentialsConfiguration(configFile);
            conf.load();
            List<String> lines = conf.getList(name, String.class);
            if (lines != null && !lines.isEmpty()) {
                if (!file.createNewFile()) {
                    throw new IOException("Failed to create file " + file);
                }
                PrintWriter writer = new PrintWriter(file);
                for (String line : lines) {
                    writer.println(line);
                }
                writer.close();
            }
            this.doneFile.setProperty("move" + name + "ToFile", true);
            this.doneFile.save();
        }
        catch (IOException e) {
            this.ess.getLogger().log(Level.SEVERE, I18n.tl("upgradingFilesError", new Object[0]), e);
        }
    }

    private void removeLinesFromConfig(File file, String regex, String info) throws Exception {
        String line;
        boolean needUpdate = false;
        BufferedReader bReader = new BufferedReader(new FileReader(file));
        File tempFile = File.createTempFile("essentialsupgrade", ".tmp.yml", this.ess.getDataFolder());
        BufferedWriter bWriter = new BufferedWriter(new FileWriter(tempFile));
        while ((line = bReader.readLine()) != null) {
            if (line.matches(regex)) {
                if (!needUpdate && info != null) {
                    bWriter.write(info, 0, info.length());
                    bWriter.newLine();
                }
                needUpdate = true;
                continue;
            }
            if (line.endsWith("\r\n")) {
                bWriter.write(line, 0, line.length() - 2);
            } else if (line.endsWith("\r") || line.endsWith("\n")) {
                bWriter.write(line, 0, line.length() - 1);
            } else {
                bWriter.write(line, 0, line.length());
            }
            bWriter.newLine();
        }
        bReader.close();
        bWriter.close();
        if (needUpdate) {
            if (!file.renameTo(new File(file.getParentFile(), file.getName().concat("." + System.currentTimeMillis() + ".upgradebackup")))) {
                throw new Exception(I18n.tl("configFileMoveError", new Object[0]));
            }
            if (!tempFile.renameTo(file)) {
                throw new Exception(I18n.tl("configFileRenameError", new Object[0]));
            }
        } else {
            tempFile.delete();
        }
    }

    private void updateUsersPowerToolsFormat() {
        File[] userFiles;
        if (this.doneFile.getBoolean("updateUsersPowerToolsFormat", false)) {
            return;
        }
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConfiguration config = new EssentialsConfiguration(file);
            try {
                Map<String, Object> powertools;
                config.load();
                if (!config.hasProperty("powertools") || (powertools = ConfigurateUtil.getRawMap(config.getSection("powertools"))).isEmpty()) continue;
                for (Map.Entry<String, Object> entry : powertools.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    ArrayList<String> temp = new ArrayList<String>();
                    temp.add((String)entry.getValue());
                    powertools.put(entry.getKey(), temp);
                }
                config.setRaw("powertools", powertools);
                config.blockingSave();
            }
            catch (RuntimeException ex) {
                this.ess.getLogger().log(Level.INFO, "File: " + file);
                throw ex;
            }
        }
        this.doneFile.setProperty("updateUsersPowerToolsFormat", true);
        this.doneFile.save();
    }

    private void updateUsersHomesFormat() {
        File[] userFiles;
        if (this.doneFile.getBoolean("updateUsersHomesFormat", false)) {
            return;
        }
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConfiguration config = new EssentialsConfiguration(file);
            try {
                Set<String> worlds;
                config.load();
                if (!config.hasProperty("home") || !config.hasProperty("home.default")) continue;
                String defworld = config.getString("home.default", null);
                Location defloc = this.getFakeLocation(config.getRootNode(), "home.worlds." + defworld);
                if (defloc != null) {
                    config.setProperty("homes.home", defloc);
                }
                if ((worlds = ConfigurateUtil.getKeys(config.getSection("home.worlds"))).isEmpty()) continue;
                for (String world : worlds) {
                    Location loc;
                    if (defworld.equalsIgnoreCase(world) || (loc = this.getFakeLocation(config.getRootNode(), "home.worlds." + world)) == null) continue;
                    String worldName = loc.getWorld().getName().toLowerCase(Locale.ENGLISH);
                    config.setProperty("homes." + worldName, loc);
                }
                config.removeProperty("home");
                config.blockingSave();
            }
            catch (RuntimeException ex) {
                this.ess.getLogger().log(Level.INFO, "File: " + file);
                throw ex;
            }
        }
        this.doneFile.setProperty("updateUsersHomesFormat", true);
        this.doneFile.save();
    }

    private void sanitizeAllUserFilenames() {
        File[] listOfFiles;
        if (this.doneFile.getBoolean("sanitizeAllUserFilenames", false)) {
            return;
        }
        File usersFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!usersFolder.exists()) {
            return;
        }
        for (File listOfFile : listOfFiles = usersFolder.listFiles()) {
            String sanitizedFilename;
            String filename = listOfFile.getName();
            if (!listOfFile.isFile() || !filename.endsWith(".yml") || (sanitizedFilename = StringUtil.sanitizeFileName(filename.substring(0, filename.length() - 4)) + ".yml").equals(filename)) continue;
            File tmpFile = new File(listOfFile.getParentFile(), sanitizedFilename + ".tmp");
            File newFile = new File(listOfFile.getParentFile(), sanitizedFilename);
            if (!listOfFile.renameTo(tmpFile)) {
                this.ess.getLogger().log(Level.WARNING, I18n.tl("userdataMoveError", filename, sanitizedFilename));
                continue;
            }
            if (newFile.exists()) {
                this.ess.getLogger().log(Level.WARNING, I18n.tl("duplicatedUserdata", filename, sanitizedFilename));
                continue;
            }
            if (tmpFile.renameTo(newFile)) continue;
            this.ess.getLogger().log(Level.WARNING, I18n.tl("userdataMoveBackError", sanitizedFilename, sanitizedFilename));
        }
        this.doneFile.setProperty("sanitizeAllUserFilenames", true);
        this.doneFile.save();
    }

    private World getFakeWorld(String name) {
        File bukkitDirectory = this.ess.getDataFolder().getParentFile().getParentFile();
        File worldDirectory = new File(bukkitDirectory, name);
        if (worldDirectory.exists() && worldDirectory.isDirectory()) {
            return new FakeWorld(worldDirectory.getName(), World.Environment.NORMAL);
        }
        return null;
    }

    public Location getFakeLocation(CommentedConfigurationNode config, String path) {
        String worldName = config.getString((path != null ? path + "." : "") + "world");
        if (worldName == null || worldName.isEmpty()) {
            return null;
        }
        World world = this.getFakeWorld(worldName);
        if (world == null) {
            return null;
        }
        return new Location(world, ((CommentedConfigurationNode)config.node(new Object[]{"x"})).getDouble(0.0), ((CommentedConfigurationNode)config.node(new Object[]{"y"})).getDouble(0.0), ((CommentedConfigurationNode)config.node(new Object[]{"z"})).getDouble(0.0), ((CommentedConfigurationNode)config.node(new Object[]{"yaw"})).getFloat(0.0f), ((CommentedConfigurationNode)config.node(new Object[]{"pitch"})).getFloat(0.0f));
    }

    private void deleteOldItemsCsv() {
        if (this.doneFile.getBoolean("deleteOldItemsCsv", false)) {
            return;
        }
        File file = new File(this.ess.getDataFolder(), "items.csv");
        if (file.exists()) {
            try {
                HashSet<BigInteger> oldconfigs = new HashSet<BigInteger>();
                oldconfigs.add(new BigInteger("66ec40b09ac167079f558d1099e39f10", 16));
                oldconfigs.add(new BigInteger("34284de1ead43b0bee2aae85e75c041d", 16));
                oldconfigs.add(new BigInteger("c33bc9b8ee003861611bbc2f48eb6f4f", 16));
                oldconfigs.add(new BigInteger("6ff17925430735129fc2a02f830c1daa", 16));
                MessageDigest digest = ManagedFile.getDigest();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[1024];
                try (DigestInputStream dis = new DigestInputStream(bis, digest);){
                    while (dis.read(buffer) != -1) {
                    }
                }
                BigInteger hash = new BigInteger(1, digest.digest());
                if (oldconfigs.contains(hash) && !file.delete()) {
                    throw new IOException("Could not delete file " + file);
                }
                this.doneFile.setProperty("deleteOldItemsCsv", true);
                this.doneFile.save();
            }
            catch (IOException ex) {
                this.ess.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void updateSpawnsToNewSpawnsConfig() {
        if (this.doneFile.getBoolean("updateSpawnsToNewSpawnsConfig", false)) {
            return;
        }
        File configFile = new File(this.ess.getDataFolder(), "spawn.yml");
        if (configFile.exists()) {
            EssentialsConfiguration config = new EssentialsConfiguration(configFile);
            try {
                config.load();
                if (!config.hasProperty("spawns")) {
                    for (Map.Entry<String, CommentedConfigurationNode> entry : config.getMap().entrySet()) {
                        Location loc = this.getFakeLocation(entry.getValue(), entry.getKey());
                        config.setProperty(entry.getKey(), loc);
                    }
                    if (!configFile.renameTo(new File(this.ess.getDataFolder(), "spawn.yml.old"))) {
                        throw new Exception(I18n.tl("fileRenameError", "spawn.yml"));
                    }
                    config.blockingSave();
                }
            }
            catch (Exception ex) {
                this.ess.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.doneFile.setProperty("updateSpawnsToNewSpawnsConfig", true);
        this.doneFile.save();
    }

    private void updateJailsToNewJailsConfig() {
        if (this.doneFile.getBoolean("updateJailsToNewJailsConfig", false)) {
            return;
        }
        File configFile = new File(this.ess.getDataFolder(), "jail.yml");
        if (configFile.exists()) {
            EssentialsConfiguration config = new EssentialsConfiguration(configFile);
            try {
                config.load();
                if (!config.hasProperty("jails")) {
                    for (Map.Entry<String, CommentedConfigurationNode> entry : config.getMap().entrySet()) {
                        Location loc = this.getFakeLocation(entry.getValue(), entry.getKey());
                        config.setProperty(entry.getKey(), loc);
                    }
                    if (!configFile.renameTo(new File(this.ess.getDataFolder(), "jail.yml.old"))) {
                        throw new Exception(I18n.tl("fileRenameError", "jail.yml"));
                    }
                    config.blockingSave();
                }
            }
            catch (Exception ex) {
                this.ess.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.doneFile.setProperty("updateJailsToNewJailsConfig", true);
        this.doneFile.save();
    }

    private void warnMetrics() {
        if (this.doneFile.getBoolean("warnMetrics", false)) {
            return;
        }
        this.doneFile.setProperty("warnMetrics", true);
        this.doneFile.save();
    }

    private void uuidFileChange() {
        if (this.doneFile.getBoolean("uuidFileChange", false)) {
            return;
        }
        Boolean ignoreUFCache = this.doneFile.getBoolean("ignore-userfiles-cache", false);
        File userdir = new File(this.ess.getDataFolder(), "userdata");
        if (!userdir.exists()) {
            return;
        }
        int countFiles = 0;
        int countReqFiles = 0;
        for (String string : userdir.list()) {
            if (!string.endsWith(".yml") || string.length() < 5) continue;
            ++countFiles;
            String name = string.substring(0, string.length() - 4);
            UUID uuid = null;
            try {
                uuid = UUID.fromString(name);
            }
            catch (IllegalArgumentException ex) {
                ++countReqFiles;
            }
            if (countFiles > 100) break;
        }
        if (countReqFiles < 1) {
            return;
        }
        this.ess.getLogger().info("#### Starting Essentials UUID userdata conversion in a few seconds. ####");
        this.ess.getLogger().info("We recommend you take a backup of your server before upgrading from the old username system.");
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EssentialsUpgrade.uuidFileConvert(this.ess, ignoreUFCache);
        this.doneFile.setProperty("uuidFileChange", true);
        this.doneFile.save();
    }

    public void banFormatChange() {
        if (this.doneFile.getBoolean("banFormatChange", false)) {
            return;
        }
        this.ess.getLogger().info("Starting Essentials ban format conversion");
        File userdir = new File(this.ess.getDataFolder(), "userdata");
        if (!userdir.exists()) {
            return;
        }
        int countFiles = 0;
        this.ess.getLogger().info("Found " + userdir.list().length + " files to convert...");
        for (String string : userdir.list()) {
            if (!string.endsWith(".yml") || string.length() < 5) continue;
            int showProgress = countFiles % 250;
            if (showProgress == 0) {
                this.ess.getLogger().info("Converted " + countFiles + "/" + userdir.list().length);
            }
            ++countFiles;
            File pFile = new File(userdir, string);
            EssentialsConfiguration conf = new EssentialsConfiguration(pFile);
            conf.load();
            String banReason = conf.hasProperty("ban.reason") ? conf.getString("ban.reason", null) : null;
            String playerName = conf.getString("lastAccountName", null);
            if (playerName != null && playerName.length() > 1 && banReason != null && banReason.length() > 1) {
                long banTimeout;
                try {
                    banTimeout = conf.hasProperty("ban.timeout") ? Long.parseLong(conf.getString("ban.timeout", null)) : 0L;
                }
                catch (NumberFormatException n) {
                    banTimeout = 0L;
                }
                if (BanLookup.isBanned(this.ess, playerName).booleanValue()) {
                    this.updateBan(playerName, banReason, banTimeout);
                }
            }
            conf.removeProperty("ban");
            conf.save();
        }
        this.doneFile.setProperty("banFormatChange", true);
        this.doneFile.save();
        this.ess.getLogger().info("Ban format update complete.");
    }

    private void updateBan(String playerName, String banReason, Long banTimeout) {
        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(playerName, banReason, banTimeout == 0L ? null : new Date(banTimeout), "Console");
    }

    public void generateUidCache() {
        if (this.doneFile.getBoolean("newUidCacheBuilt", false)) {
            return;
        }
        File usermapFile = new File(this.ess.getDataFolder(), "usermap.bin");
        File uidsFile = new File(this.ess.getDataFolder(), "uuids.bin");
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.isDirectory() || usermapFile.exists() || uidsFile.exists()) {
            this.ess.getLogger().warning("Missing userdata folder, aborting");
            this.doneFile.setProperty("newUidCacheBuilt", true);
            this.doneFile.save();
            return;
        }
        try {
            if (!usermapFile.createNewFile() || !uidsFile.createNewFile()) {
                this.ess.getLogger().warning("Couldn't create usermap.bin or uuids.bin, aborting");
                return;
            }
            HashMap<UUID, Long> uuids = new HashMap<UUID, Long>();
            HashMap<String, UUID> nameToUuidMap = new HashMap<String, UUID>();
            File[] files = userdataFolder.listFiles(YML_FILTER);
            if (files != null) {
                for (File file : files) {
                    try {
                        String fileName = file.getName();
                        UUID uuid = UUID.fromString(fileName.substring(0, fileName.length() - 4));
                        EssentialsConfiguration config = new EssentialsConfiguration(file);
                        config.load();
                        String name = config.getString("last-account-name", null);
                        name = this.ess.getSettings().isSafeUsermap() ? StringUtil.safeString(name) : name;
                        long time = config.getLong("timestamps.logout", 0L);
                        if (name == null) continue;
                        if (nameToUuidMap.containsKey(name)) {
                            UUID oldUuid = (UUID)nameToUuidMap.get(name);
                            if (oldUuid.version() < uuid.version() || oldUuid.version() == uuid.version() && (Long)uuids.get(oldUuid) < time) {
                                this.ess.getLogger().warning("New UUID found for " + name + ": " + uuid + " (old: " + oldUuid + "). Replacing.");
                                uuids.remove(oldUuid);
                            } else {
                                this.ess.getLogger().warning("Found UUID for " + name + ": " + uuid + " (old: " + oldUuid + "). Skipping.");
                                continue;
                            }
                        }
                        uuids.put(uuid, config.getLong("timestamps.logout", 0L));
                        nameToUuidMap.put(name, uuid);
                    }
                    catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                        // empty catch block
                    }
                }
            }
            if (!nameToUuidMap.isEmpty()) {
                ModernUUIDCache.writeNameUuidMap(usermapFile, nameToUuidMap);
            }
            if (!uuids.isEmpty()) {
                ModernUUIDCache.writeUuidCache(uidsFile, uuids.keySet());
            }
            this.doneFile.setProperty("newUidCacheBuilt", true);
            this.doneFile.save();
        }
        catch (IOException e) {
            this.ess.getLogger().log(Level.SEVERE, "Error while generating initial uuids/names cache", e);
        }
    }

    public void beforeSettings() {
        if (!this.ess.getDataFolder().exists()) {
            this.ess.getDataFolder().mkdirs();
        }
        this.moveMotdRulesToFile("motd");
        this.moveMotdRulesToFile("rules");
    }

    public void preModules() {
        this.generateUidCache();
    }

    public void afterSettings() {
        this.sanitizeAllUserFilenames();
        this.updateUsersPowerToolsFormat();
        this.updateUsersHomesFormat();
        this.deleteOldItemsCsv();
        this.updateSpawnsToNewSpawnsConfig();
        this.updateJailsToNewJailsConfig();
        this.uuidFileChange();
        this.banFormatChange();
        this.warnMetrics();
        this.convertIgnoreList();
        this.convertStupidCamelCaseUserdataKeys();
        this.convertMailList();
        this.purgeBrokenNpcAccounts();
    }
}

