/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.BanList;
import org.bukkit.Server;

public class Commandban
extends EssentialsCommand {
    public Commandban() {
        super("ban");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        User user;
        boolean nomatch = false;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        try {
            user = this.getPlayer(server, args, 0, true, true);
        }
        catch (PlayerNotFoundException e) {
            nomatch = true;
            user = this.ess.getUser(new OfflinePlayer(args[0], this.ess.getServer()));
        }
        if (!user.getBase().isOnline()) {
            if (sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.ban.offline")) {
                throw new Exception(I18n.tl("banExemptOffline", new Object[0]));
            }
        } else if (user.isAuthorized("essentials.ban.exempt") && sender.isPlayer()) {
            throw new Exception(I18n.tl("banExempt", new Object[0]));
        }
        String senderName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : "Console";
        String senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        String banReason = args.length > 1 ? FormatUtil.replaceFormat(Commandban.getFinalArg(args, 1).replace("\\n", "\n").replace("|", "\n")) : I18n.tl("defaultBanReason", new Object[0]);
        this.ess.getServer().getBanList(BanList.Type.NAME).addBan(user.getName(), banReason, null, senderName);
        String banDisplay = I18n.tl("banFormat", banReason, senderDisplayName);
        user.getBase().kickPlayer(banDisplay);
        this.ess.getLogger().log(Level.INFO, I18n.tl("playerBanned", senderDisplayName, user.getName(), banDisplay));
        if (nomatch) {
            sender.sendMessage(I18n.tl("userUnknown", user.getName()));
        }
        this.ess.broadcastMessage("essentials.ban.notify", I18n.tl("playerBanned", senderDisplayName, user.getName(), banReason));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

