/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;

public class Commandeditsign
extends EssentialsCommand {
    public Commandeditsign() {
        super("editsign");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        block21: {
            if (args.length == 0 || args.length > 1 && !NumberUtil.isInt(args[1])) {
                throw new NotEnoughArgumentsException();
            }
            Block target = user.getTargetBlock(5);
            if (!(target.getState() instanceof Sign)) {
                throw new Exception(I18n.tl("editsignCommandTarget", new Object[0]));
            }
            Sign sign = (Sign)target.getState();
            try {
                if (args[0].equalsIgnoreCase("set") && args.length > 2) {
                    String[] existingLines = sign.getLines();
                    int line = Integer.parseInt(args[1]) - 1;
                    String text = FormatUtil.formatString(user, "essentials.editsign", Commandeditsign.getFinalArg(args, 2)).trim();
                    if (ChatColor.stripColor((String)text).length() > 15 && !user.isAuthorized("essentials.editsign.unlimited")) {
                        throw new Exception(I18n.tl("editsignCommandLimit", new Object[0]));
                    }
                    existingLines[line] = text;
                    if (this.callSignEvent(sign, user.getBase(), existingLines)) {
                        return;
                    }
                    user.sendMessage(I18n.tl("editsignCommandSetSuccess", line + 1, text));
                    break block21;
                }
                if (args[0].equalsIgnoreCase("clear")) {
                    if (args.length == 1) {
                        String[] existingLines = sign.getLines();
                        for (int i = 0; i < 4; ++i) {
                            existingLines[i] = "";
                        }
                        if (this.callSignEvent(sign, user.getBase(), existingLines)) {
                            return;
                        }
                        user.sendMessage(I18n.tl("editsignCommandClear", new Object[0]));
                    } else {
                        String[] existingLines = sign.getLines();
                        int line = Integer.parseInt(args[1]) - 1;
                        existingLines[line] = "";
                        if (this.callSignEvent(sign, user.getBase(), existingLines)) {
                            return;
                        }
                        user.sendMessage(I18n.tl("editsignCommandClearLine", line + 1));
                    }
                    break block21;
                }
                if (args[0].equalsIgnoreCase("copy")) {
                    int line;
                    int n = line = args.length == 1 ? -1 : Integer.parseInt(args[1]) - 1;
                    if (line == -1) {
                        for (int i = 0; i < 4; ++i) {
                            user.getSignCopy().set(i, FormatUtil.unformatString(user, "essentials.editsign", sign.getLine(i)));
                        }
                        user.sendMessage(I18n.tl("editsignCopy", commandLabel));
                    } else {
                        user.getSignCopy().set(line, FormatUtil.unformatString(user, "essentials.editsign", sign.getLine(line)));
                        user.sendMessage(I18n.tl("editsignCopyLine", line + 1, commandLabel));
                    }
                    break block21;
                }
                if (args[0].equalsIgnoreCase("paste")) {
                    int line = args.length == 1 ? -1 : Integer.parseInt(args[1]) - 1;
                    String[] existingLines = sign.getLines();
                    if (line == -1) {
                        for (int i = 0; i < 4; ++i) {
                            existingLines[i] = FormatUtil.formatString(user, "essentials.editsign", user.getSignCopy().get(i));
                        }
                        user.sendMessage(I18n.tl("editsignPaste", commandLabel));
                    } else {
                        existingLines[line] = FormatUtil.formatString(user, "essentials.editsign", user.getSignCopy().get(line));
                        user.sendMessage(I18n.tl("editsignPasteLine", line + 1, commandLabel));
                    }
                    this.callSignEvent(sign, user.getBase(), existingLines);
                    break block21;
                }
                throw new NotEnoughArgumentsException();
            }
            catch (IndexOutOfBoundsException e) {
                throw new Exception(I18n.tl("editsignCommandNoLine", new Object[0]), e);
            }
        }
    }

    private boolean callSignEvent(Sign sign, Player player, String[] lines) {
        SignChangeEvent event = new SignChangeEvent(sign.getBlock(), player, lines);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info("SignChangeEvent canceled for /editsign execution by " + player.getName());
            }
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            sign.setLine(i, lines[i]);
        }
        sign.update();
        return false;
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"set", "clear", "copy", "paste"});
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"});
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set") && NumberUtil.isPositiveInt(args[1])) {
            int line = Integer.parseInt(args[1]);
            Block target = user.getTargetBlock(5);
            if (target.getState() instanceof Sign && line <= 4) {
                Sign sign = (Sign)target.getState();
                return Lists.newArrayList((Object[])new String[]{FormatUtil.unformatString(user, "essentials.editsign", sign.getLine(line - 1))});
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

