/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.Enchantments;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.MetaItemStack;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class Commandenchant
extends EssentialsCommand {
    public Commandenchant() {
        super("enchant");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        ItemStack stack = user.getItemInHand();
        if (stack == null || stack.getType() == Material.AIR) {
            throw new Exception(I18n.tl("nothingInHand", new Object[0]));
        }
        if (args.length == 0) {
            TreeSet<String> usableEnchants = new TreeSet<String>();
            for (Map.Entry<String, Enchantment> entry : Enchantments.entrySet()) {
                String name = entry.getValue().getName().toLowerCase(Locale.ENGLISH);
                if (!usableEnchants.contains(name) && (!user.isAuthorized("essentials.enchantments." + name) || !entry.getValue().canEnchantItem(stack))) continue;
                usableEnchants.add(entry.getKey());
            }
            throw new NotEnoughArgumentsException(I18n.tl("enchantments", StringUtil.joinList(usableEnchants.toArray())));
        }
        int level = 1;
        if (args.length > 1) {
            try {
                level = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                throw new NotEnoughArgumentsException();
            }
        }
        MetaItemStack metaStack = new MetaItemStack(stack);
        Enchantment enchantment = metaStack.getEnchantment(user, args[0]);
        metaStack.addEnchantment(user.getSource(), this.ess.getSettings().allowUnsafeEnchantments() && user.isAuthorized("essentials.enchantments.allowunsafe"), enchantment, level);
        Inventories.setItemInMainHand(user.getBase(), metaStack.getItemStack());
        user.getBase().updateInventory();
        String enchantName = enchantment.getName().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        if (level == 0) {
            user.sendMessage(I18n.tl("enchantmentRemoved", enchantName));
        } else {
            user.sendMessage(I18n.tl("enchantmentApplied", enchantName));
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(Enchantments.keySet());
        }
        if (args.length == 2) {
            Enchantment enchantment = Enchantments.getByName(args[0]);
            if (enchantment == null) {
                return Collections.emptyList();
            }
            int min = enchantment.getStartLevel();
            int max = enchantment.getMaxLevel();
            ArrayList options = Lists.newArrayList();
            for (int i = min; i <= max; ++i) {
                options.add(Integer.toString(i));
            }
            return options;
        }
        return Collections.emptyList();
    }
}

