/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.TriState;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class Commandhat
extends EssentialsCommand {
    public static final String PERM_PREFIX = "essentials.hat.prevent-type.";

    public Commandhat() {
        super("hat");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length == 0 || !args[0].contains("rem") && !args[0].contains("off") && !args[0].equalsIgnoreCase("0")) {
            ItemStack hand = Inventories.getItemInMainHand(user.getBase());
            if (hand == null || hand.getType() == Material.AIR) {
                user.sendMessage(I18n.tl("hatFail", new Object[0]));
                return;
            }
            TriState wildcard = user.isAuthorizedExact("essentials.hat.prevent-type.*");
            TriState material = user.isAuthorizedExact(PERM_PREFIX + hand.getType().name().toLowerCase());
            if (wildcard == TriState.TRUE && material != TriState.FALSE || wildcard != TriState.TRUE && material == TriState.TRUE) {
                user.sendMessage(I18n.tl("hatFail", new Object[0]));
                return;
            }
            if (hand.getType().getMaxDurability() != 0) {
                user.sendMessage(I18n.tl("hatArmor", new Object[0]));
                return;
            }
            PlayerInventory inv = user.getBase().getInventory();
            ItemStack head = inv.getHelmet();
            if (VersionUtil.getServerBukkitVersion().isHigherThan(VersionUtil.v1_9_4_R01) && head != null && head.getEnchantments().containsKey(Enchantment.BINDING_CURSE) && !user.isAuthorized("essentials.hat.ignore-binding")) {
                user.sendMessage(I18n.tl("hatCurse", new Object[0]));
                return;
            }
            inv.setHelmet(hand);
            Inventories.setItemInMainHand(user.getBase(), head);
            user.sendMessage(I18n.tl("hatPlaced", new Object[0]));
            return;
        }
        PlayerInventory inv = user.getBase().getInventory();
        ItemStack head = inv.getHelmet();
        if (head == null || head.getType() == Material.AIR) {
            user.sendMessage(I18n.tl("hatEmpty", new Object[0]));
        } else if (VersionUtil.getServerBukkitVersion().isHigherThan(VersionUtil.v1_9_4_R01) && head.getEnchantments().containsKey(Enchantment.BINDING_CURSE) && !user.isAuthorized("essentials.hat.ignore-binding")) {
            user.sendMessage(I18n.tl("hatCurse", new Object[0]));
        } else {
            ItemStack air = new ItemStack(Material.AIR);
            inv.setHelmet(air);
            Inventories.addItem(user.getBase(), head);
            user.sendMessage(I18n.tl("hatRemoved", new Object[0]));
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"remove", "wear"});
        }
        return Collections.emptyList();
    }
}

