/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Server;

public class Commandhelpop
extends EssentialsCommand {
    public Commandhelpop() {
        super("helpop");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        user.setDisplayNick();
        String message = this.sendMessage(server, user.getDisplayName(), args);
        if (!user.isAuthorized("essentials.helpop.receive")) {
            user.sendMessage(message);
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        this.sendMessage(server, Console.DISPLAY_NAME, args);
    }

    private String sendMessage(Server server, String from, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String message = I18n.tl("helpOp", from, FormatUtil.stripFormat(Commandhelpop.getFinalArg(args, 0)));
        this.ess.getLogger().log(Level.INFO, message);
        this.ess.broadcastMessage("essentials.helpop.receive", message);
        return message;
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        return Collections.emptyList();
    }
}

