/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.items;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ManagedFile;
import com.earth2me.essentials.items.AbstractItemDb;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.StringUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class LegacyItemDb
extends AbstractItemDb {
    private final transient Map<String, Integer> items = new HashMap<String, Integer>();
    private final transient Map<ItemData, List<String>> names = new HashMap<ItemData, List<String>>();
    private final transient Map<ItemData, String> primaryName = new HashMap<ItemData, String>();
    private final transient Map<Integer, ItemData> legacyIds = new HashMap<Integer, ItemData>();
    private final transient Map<String, Short> durabilities = new HashMap<String, Short>();
    private final transient Map<String, String> nbtData = new HashMap<String, String>();
    private final transient ManagedFile file;
    private final transient Pattern splitPattern = Pattern.compile("((.*)[:+',;.](\\d+))");
    private final transient Pattern csvSplitPattern = Pattern.compile("(\"([^\"]*)\"|[^,]*)(,|$)");

    public LegacyItemDb(IEssentials ess) {
        super(ess);
        this.file = new ManagedFile("items.csv", ess);
    }

    @Override
    public void reloadConfig() {
        List<String> lines = this.file.getLines();
        if (lines.isEmpty()) {
            return;
        }
        this.ready = false;
        this.durabilities.clear();
        this.items.clear();
        this.names.clear();
        this.primaryName.clear();
        for (String string : lines) {
            List<Object> nameList;
            ItemData itemData;
            if (string.length() > 0 && string.charAt(0) == '#') continue;
            String itemName = null;
            int numeric = -1;
            short data = 0;
            String nbt = null;
            int col = 0;
            Matcher matcher = this.csvSplitPattern.matcher(string);
            block7: while (matcher.find()) {
                String match = matcher.group(1);
                if (StringUtil.stripToNull(match) == null) continue;
                match = StringUtil.strip(match.trim(), "\"");
                switch (col) {
                    case 0: {
                        itemName = match.toLowerCase(Locale.ENGLISH);
                        break;
                    }
                    case 1: {
                        numeric = Integer.parseInt(match);
                        break;
                    }
                    case 2: {
                        data = Short.parseShort(match);
                        break;
                    }
                    case 3: {
                        nbt = StringUtil.stripToNull(match);
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                ++col;
            }
            if (itemName == null || numeric < 0) continue;
            this.durabilities.put(itemName, data);
            this.items.put(itemName, numeric);
            if (nbt != null) {
                this.nbtData.put(itemName, nbt);
            }
            if (this.names.containsKey(itemData = new ItemData(numeric, data))) {
                nameList = this.names.get(itemData);
                nameList.add(itemName);
            } else {
                nameList = new ArrayList<String>();
                nameList.add(itemName);
                this.names.put(itemData, nameList);
                this.primaryName.put(itemData, itemName);
            }
            this.legacyIds.put(numeric, itemData);
        }
        for (List list : this.names.values()) {
            list.sort(LengthCompare.INSTANCE);
        }
        this.ess.getLogger().info(String.format("Loaded %s items from items.csv.", this.listNames().size()));
        this.ready = true;
    }

    @Override
    public ItemStack get(String id, boolean useResolvers) throws Exception {
        Material MOB_SPAWNER;
        Material matFromName;
        String itemname;
        ItemStack resolved;
        if (useResolvers && (resolved = this.tryResolverDeserialize(id)) != null) {
            return resolved;
        }
        int itemid = 0;
        short metaData = 0;
        Matcher parts = this.splitPattern.matcher(id);
        if (parts.matches()) {
            itemname = parts.group(2);
            metaData = Short.parseShort(parts.group(3));
        } else {
            itemname = id;
        }
        if (NumberUtil.isInt(itemname)) {
            itemid = Integer.parseInt(itemname);
        } else if (NumberUtil.isInt(id)) {
            itemid = Integer.parseInt(id);
        } else {
            itemname = itemname.toLowerCase(Locale.ENGLISH);
        }
        if (itemid < 1 && this.items.containsKey(itemname)) {
            itemid = this.items.get(itemname);
            if (this.durabilities.containsKey(itemname) && metaData == 0) {
                metaData = this.durabilities.get(itemname);
            }
        }
        if (itemid < 1 && (matFromName = EnumUtil.getMaterial(itemname.toUpperCase())) != null) {
            itemid = matFromName.getId();
        }
        if (itemid < 1) {
            throw new Exception(I18n.tl("unknownItemName", itemname));
        }
        ItemData data = this.legacyIds.get(itemid);
        if (data == null) {
            throw new Exception(I18n.tl("unknownItemId", itemid));
        }
        Material mat = this.getFromLegacy(itemid, (byte)metaData);
        ItemStack retval = new ItemStack(mat);
        if (this.nbtData.containsKey(itemname)) {
            String nbt = this.nbtData.get(itemname);
            if (nbt.startsWith("*")) {
                nbt = this.nbtData.get(nbt.substring(1));
            }
            retval = this.ess.getServer().getUnsafe().modifyItemStack(retval, nbt);
        }
        if (mat == (MOB_SPAWNER = EnumUtil.getMaterial("SPAWNER", "MOB_SPAWNER"))) {
            if (metaData == 0) {
                metaData = EntityType.PIG.getTypeId();
            }
            try {
                retval = this.ess.getSpawnerItemProvider().setEntityType(retval, EntityType.fromId((int)metaData));
                this.ess.getPersistentDataProvider().set(retval, "convert", "true");
            }
            catch (IllegalArgumentException e) {
                throw new Exception("Can't spawn entity ID " + metaData + " from mob spawners.");
            }
        }
        if (mat.name().contains("MONSTER_EGG")) {
            EntityType type;
            try {
                type = EntityType.fromId((int)metaData);
            }
            catch (IllegalArgumentException e) {
                throw new Exception("Can't spawn entity ID " + metaData + " from spawn eggs.");
            }
            retval = this.ess.getSpawnEggProvider().createEggItem(type);
        } else if (mat.name().endsWith("POTION") && VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_11_R01)) {
            retval = this.ess.getPotionMetaProvider().createPotionItem(mat, metaData);
        } else {
            retval.setDurability(metaData);
        }
        retval.setAmount(mat.getMaxStackSize());
        return retval;
    }

    @Override
    public List<String> nameList(ItemStack item) {
        ItemData itemData = new ItemData(item.getType().getId(), item.getDurability());
        List<String> nameList = this.names.get(itemData);
        if (nameList == null && (nameList = this.names.get(itemData = new ItemData(item.getType().getId(), 0))) == null) {
            return null;
        }
        return Collections.unmodifiableList(nameList);
    }

    @Override
    public String name(ItemStack item) {
        ItemData itemData = new ItemData(item.getType().getId(), item.getDurability());
        String name = this.primaryName.get(itemData);
        if (name == null) {
            itemData = new ItemData(item.getType().getId(), 0);
            name = this.primaryName.get(itemData);
        }
        return name;
    }

    @Override
    public int getLegacyId(Material material) throws Exception {
        for (Map.Entry<String, Integer> entry : this.items.entrySet()) {
            if (!material.name().toLowerCase(Locale.ENGLISH).equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new Exception("Itemid not found for material: " + material.name());
    }

    @Override
    public Collection<String> listNames() {
        ArrayList<String> values = new ArrayList<String>(this.primaryName.values());
        values.addAll(this.getResolverNames());
        return values;
    }

    static class ItemData {
        private final int itemNo;
        private final short itemData;

        ItemData(int itemNo, short itemData) {
            this.itemNo = itemNo;
            this.itemData = itemData;
        }

        public int getItemNo() {
            return this.itemNo;
        }

        public short getItemData() {
            return this.itemData;
        }

        public int hashCode() {
            return 31 * this.itemNo ^ this.itemData;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ItemData)) {
                return false;
            }
            ItemData pairo = (ItemData)o;
            return this.itemNo == pairo.getItemNo() && this.itemData == pairo.getItemData();
        }
    }

    static class LengthCompare
    implements Comparator<String> {
        private static final LengthCompare INSTANCE = new LengthCompare();

        LengthCompare() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.length() - s2.length();
        }
    }
}

