/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class PasteUtil {
    private static final String PASTE_URL = "https://paste.gg/";
    private static final String PASTE_UPLOAD_URL = "https://api.paste.gg/v1/pastes";
    private static final ExecutorService PASTE_EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private static final Gson GSON = new Gson();

    private PasteUtil() {
    }

    public static CompletableFuture<PasteResult> createPaste(List<PasteFile> pages) {
        CompletableFuture<PasteResult> future = new CompletableFuture<PasteResult>();
        PASTE_EXECUTOR_SERVICE.submit(() -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(PASTE_UPLOAD_URL).openConnection();
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestProperty("User-Agent", "EssentialsX plugin");
                connection.setRequestProperty("Content-Type", "application/json");
                JsonObject body = new JsonObject();
                JsonArray files = new JsonArray();
                for (PasteFile page : pages) {
                    JsonObject file = new JsonObject();
                    JsonObject content = new JsonObject();
                    file.addProperty("name", page.getName());
                    content.addProperty("format", "text");
                    content.addProperty("value", page.getContents());
                    file.add("content", (JsonElement)content);
                    files.add((JsonElement)file);
                }
                body.add("files", (JsonElement)files);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(body.toString().getBytes(Charsets.UTF_8));
                }
                if (connection.getResponseCode() >= 400) {
                    future.completeExceptionally(new Error(CharStreams.toString((Readable)new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8))));
                    return;
                }
                JsonObject object = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream(), Charsets.UTF_8), JsonObject.class);
                String pasteId = object.get("result").getAsJsonObject().get("id").getAsString();
                String pasteUrl = PASTE_URL + pasteId;
                JsonElement deletionKey = object.get("result").getAsJsonObject().get("deletion_key");
                connection.disconnect();
                PasteResult result = new PasteResult(pasteId, pasteUrl, deletionKey != null ? deletionKey.getAsString() : null);
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static class PasteFile {
        private final String name;
        private final String contents;

        public PasteFile(String name, String contents) {
            this.name = name;
            this.contents = contents;
        }

        public String getName() {
            return this.name;
        }

        public String getContents() {
            return this.contents;
        }
    }

    public static class PasteResult {
        private final String pasteId;
        private final String pasteUrl;
        private final @Nullable String deletionKey;

        protected PasteResult(String pasteId, String pasteUrl, @Nullable String deletionKey) {
            this.pasteId = pasteId;
            this.pasteUrl = pasteUrl;
            this.deletionKey = deletionKey;
        }

        public String getPasteUrl() {
            return this.pasteUrl;
        }

        public @Nullable String getDeletionKey() {
            return this.deletionKey;
        }

        public String getPasteId() {
            return this.pasteId;
        }
    }
}

