/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx.keychain;

import java.nio.ByteBuffer;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.macosx.keychain.KeychainException;
import net.java.truecommons.key.macosx.keychain.KeychainImpl;
import net.java.truecommons.shed.Option;

@ThreadSafe
public abstract class Keychain
implements AutoCloseable {
    public static Keychain open() throws KeychainException {
        return new KeychainImpl();
    }

    public static Keychain open(String path, @Nullable char[] password) throws KeychainException {
        return new KeychainImpl(path, (Option<char[]>)Option.apply((Object)password));
    }

    public abstract void createItem(ItemClass var1, Map<AttributeClass, ByteBuffer> var2, ByteBuffer var3) throws KeychainException;

    public abstract void visitItems(@Nullable ItemClass var1, @Nullable Map<AttributeClass, ByteBuffer> var2, Visitor var3) throws KeychainException;

    public abstract void delete() throws KeychainException;

    @Override
    public abstract void close();

    public static enum AttributeClass {
        KEY_CLASS(0),
        KEY_PRINT_NAME(1),
        KEY_ALIAS(2),
        KEY_PERMANENT(3),
        KEY_PRIVATE(4),
        KEY_MODIFIABLE(5),
        KEY_LABEL(6),
        KEY_APPLICATION_TAG(7),
        KEY_KEY_CREATOR(8),
        KEY_KEY_KYPE(9),
        KEY_KEY_SIZE_IN_BITS(10),
        KEY_EFFECTIVE_KEY_SIZE(11),
        KEY_START_DATE(12),
        KEY_END_DATE(13),
        KEY_SENSITIVE(14),
        KEY_ALWAYS_SENSITIVE(15),
        KEY_EXTRACTABLE(16),
        KEY_NEVER_EXTRACTABLE(17),
        KEY_ENCRYPT(18),
        DEY_DECRYPT(19),
        KEY_DERIVE(20),
        DEY_SIGN(21),
        KEY_VERIFY(22),
        KEY_SIGN_RECOVER(23),
        KEY_VERIFY_RECOVER(24),
        KEY_WRAP(25),
        KEY_UNWRAP(26),
        CREATION_DATE(1667522932),
        MOD_DATE(1835295092),
        DESCRIPTION(1684370275),
        COMMENT(1768123764),
        CREATOR(1668445298),
        TYPE(1954115685),
        SCRIPT_CODE(1935897200),
        LABEL(1818321516),
        INVISIBLE(1768846953),
        NEGATIVE(1852139361),
        CUSTOM_ICON(1668641641),
        ACCOUNT(1633903476),
        SERVICE(1937138533),
        GENERIC(1734700641),
        SECURITY_DOMAIN(1935961454),
        SERVER(1936881266),
        AUTHENTICATION_TYPE(1635023216),
        PORT(1886351988),
        PATH(1885434984),
        VOLUME(1986817381),
        ADDRESS(1633969266),
        SIGNATURE(1936943463),
        PROTOCOL(1886675820),
        CERTIFICATE_TYPE(1668577648),
        CERTIFICATE_ENCODING(1667591779),
        CRL_TYPE(1668445296),
        CRL_ENCODING(1668443747),
        ALIAS(1634494835);

        private final int tag;

        @Nullable
        static AttributeClass lookup(int tag) {
            switch (tag) {
                case 0: {
                    return KEY_CLASS;
                }
                case 1: {
                    return KEY_PRINT_NAME;
                }
                case 2: {
                    return KEY_ALIAS;
                }
                case 3: {
                    return KEY_PERMANENT;
                }
                case 4: {
                    return KEY_PRIVATE;
                }
                case 5: {
                    return KEY_MODIFIABLE;
                }
                case 6: {
                    return KEY_LABEL;
                }
                case 7: {
                    return KEY_APPLICATION_TAG;
                }
                case 8: {
                    return KEY_KEY_CREATOR;
                }
                case 9: {
                    return KEY_KEY_KYPE;
                }
                case 10: {
                    return KEY_KEY_SIZE_IN_BITS;
                }
                case 11: {
                    return KEY_EFFECTIVE_KEY_SIZE;
                }
                case 12: {
                    return KEY_START_DATE;
                }
                case 13: {
                    return KEY_END_DATE;
                }
                case 14: {
                    return KEY_SENSITIVE;
                }
                case 15: {
                    return KEY_ALWAYS_SENSITIVE;
                }
                case 16: {
                    return KEY_EXTRACTABLE;
                }
                case 17: {
                    return KEY_NEVER_EXTRACTABLE;
                }
                case 18: {
                    return KEY_ENCRYPT;
                }
                case 19: {
                    return DEY_DECRYPT;
                }
                case 20: {
                    return KEY_DERIVE;
                }
                case 21: {
                    return DEY_SIGN;
                }
                case 22: {
                    return KEY_VERIFY;
                }
                case 23: {
                    return KEY_SIGN_RECOVER;
                }
                case 24: {
                    return KEY_VERIFY_RECOVER;
                }
                case 25: {
                    return KEY_WRAP;
                }
                case 26: {
                    return KEY_UNWRAP;
                }
                case 1667522932: {
                    return CREATION_DATE;
                }
                case 1835295092: {
                    return MOD_DATE;
                }
                case 1684370275: {
                    return DESCRIPTION;
                }
                case 1768123764: {
                    return COMMENT;
                }
                case 1668445298: {
                    return CREATOR;
                }
                case 1954115685: {
                    return TYPE;
                }
                case 1935897200: {
                    return SCRIPT_CODE;
                }
                case 1818321516: {
                    return LABEL;
                }
                case 1768846953: {
                    return INVISIBLE;
                }
                case 1852139361: {
                    return NEGATIVE;
                }
                case 1668641641: {
                    return CUSTOM_ICON;
                }
                case 1633903476: {
                    return ACCOUNT;
                }
                case 1937138533: {
                    return SERVICE;
                }
                case 1734700641: {
                    return GENERIC;
                }
                case 1935961454: {
                    return SECURITY_DOMAIN;
                }
                case 1936881266: {
                    return SERVER;
                }
                case 1635023216: {
                    return AUTHENTICATION_TYPE;
                }
                case 1886351988: {
                    return PORT;
                }
                case 1885434984: {
                    return PATH;
                }
                case 1986817381: {
                    return VOLUME;
                }
                case 1633969266: {
                    return ADDRESS;
                }
                case 1936943463: {
                    return SIGNATURE;
                }
                case 1886675820: {
                    return PROTOCOL;
                }
                case 1668577648: {
                    return CERTIFICATE_TYPE;
                }
                case 1667591779: {
                    return CERTIFICATE_ENCODING;
                }
                case 1668445296: {
                    return CRL_TYPE;
                }
                case 1668443747: {
                    return CRL_ENCODING;
                }
                case 1634494835: {
                    return ALIAS;
                }
            }
            return null;
        }

        private AttributeClass(int tag) {
            this.tag = tag;
        }

        int getTag() {
            return this.tag;
        }
    }

    public static final class ItemClass
    extends Enum<ItemClass> {
        public static final /* enum */ ItemClass ANY_ITEM = new ItemClass(10, new AttributeClass[0]);
        public static final /* enum */ ItemClass CERT_ITEM = new ItemClass(12, AttributeClass.KEY_CLASS, AttributeClass.KEY_PRINT_NAME, AttributeClass.KEY_ALIAS, AttributeClass.KEY_PERMANENT, AttributeClass.KEY_PRIVATE, AttributeClass.KEY_MODIFIABLE, AttributeClass.KEY_LABEL, AttributeClass.KEY_APPLICATION_TAG, AttributeClass.KEY_KEY_CREATOR, AttributeClass.KEY_KEY_KYPE, AttributeClass.KEY_KEY_SIZE_IN_BITS, AttributeClass.KEY_EFFECTIVE_KEY_SIZE, AttributeClass.KEY_START_DATE, AttributeClass.KEY_END_DATE, AttributeClass.KEY_SENSITIVE, AttributeClass.KEY_ALWAYS_SENSITIVE, AttributeClass.KEY_EXTRACTABLE, AttributeClass.KEY_NEVER_EXTRACTABLE, AttributeClass.KEY_ENCRYPT, AttributeClass.DEY_DECRYPT, AttributeClass.KEY_DERIVE, AttributeClass.DEY_SIGN, AttributeClass.KEY_VERIFY, AttributeClass.KEY_SIGN_RECOVER, AttributeClass.KEY_VERIFY_RECOVER, AttributeClass.KEY_WRAP, AttributeClass.KEY_UNWRAP);
        public static final /* enum */ ItemClass CRL_ITEM = new ItemClass(12, AttributeClass.KEY_CLASS, AttributeClass.KEY_PRINT_NAME, AttributeClass.KEY_ALIAS, AttributeClass.KEY_PERMANENT, AttributeClass.KEY_PRIVATE, AttributeClass.KEY_MODIFIABLE, AttributeClass.KEY_LABEL, AttributeClass.KEY_APPLICATION_TAG, AttributeClass.KEY_KEY_CREATOR, AttributeClass.KEY_KEY_KYPE, AttributeClass.KEY_KEY_SIZE_IN_BITS, AttributeClass.KEY_EFFECTIVE_KEY_SIZE, AttributeClass.KEY_START_DATE, AttributeClass.KEY_END_DATE, AttributeClass.KEY_SENSITIVE, AttributeClass.KEY_ALWAYS_SENSITIVE, AttributeClass.KEY_EXTRACTABLE, AttributeClass.KEY_NEVER_EXTRACTABLE, AttributeClass.KEY_ENCRYPT, AttributeClass.DEY_DECRYPT, AttributeClass.KEY_DERIVE, AttributeClass.DEY_SIGN, AttributeClass.KEY_VERIFY, AttributeClass.KEY_SIGN_RECOVER, AttributeClass.KEY_VERIFY_RECOVER, AttributeClass.KEY_WRAP, AttributeClass.KEY_UNWRAP);
        public static final /* enum */ ItemClass POLICY_ITEM = new ItemClass(13, AttributeClass.KEY_CLASS, AttributeClass.KEY_PRINT_NAME, AttributeClass.KEY_ALIAS, AttributeClass.KEY_PERMANENT, AttributeClass.KEY_PRIVATE, AttributeClass.KEY_MODIFIABLE, AttributeClass.KEY_LABEL, AttributeClass.KEY_APPLICATION_TAG, AttributeClass.KEY_KEY_CREATOR, AttributeClass.KEY_KEY_KYPE, AttributeClass.KEY_KEY_SIZE_IN_BITS, AttributeClass.KEY_EFFECTIVE_KEY_SIZE, AttributeClass.KEY_START_DATE, AttributeClass.KEY_END_DATE, AttributeClass.KEY_SENSITIVE, AttributeClass.KEY_ALWAYS_SENSITIVE, AttributeClass.KEY_EXTRACTABLE, AttributeClass.KEY_NEVER_EXTRACTABLE, AttributeClass.KEY_ENCRYPT, AttributeClass.DEY_DECRYPT, AttributeClass.KEY_DERIVE, AttributeClass.DEY_SIGN, AttributeClass.KEY_VERIFY, AttributeClass.KEY_SIGN_RECOVER, AttributeClass.KEY_VERIFY_RECOVER, AttributeClass.KEY_WRAP, AttributeClass.KEY_UNWRAP);
        public static final /* enum */ ItemClass GENERIC_ITEM = new ItemClass(14, AttributeClass.KEY_CLASS, AttributeClass.KEY_PRINT_NAME, AttributeClass.KEY_ALIAS, AttributeClass.KEY_PERMANENT, AttributeClass.KEY_PRIVATE, AttributeClass.KEY_MODIFIABLE, AttributeClass.KEY_LABEL, AttributeClass.KEY_APPLICATION_TAG, AttributeClass.KEY_KEY_CREATOR, AttributeClass.KEY_KEY_KYPE, AttributeClass.KEY_KEY_SIZE_IN_BITS, AttributeClass.KEY_EFFECTIVE_KEY_SIZE, AttributeClass.KEY_START_DATE, AttributeClass.KEY_END_DATE, AttributeClass.KEY_SENSITIVE, AttributeClass.KEY_ALWAYS_SENSITIVE, AttributeClass.KEY_EXTRACTABLE, AttributeClass.KEY_NEVER_EXTRACTABLE, AttributeClass.KEY_ENCRYPT, AttributeClass.DEY_DECRYPT, AttributeClass.KEY_DERIVE, AttributeClass.DEY_SIGN, AttributeClass.KEY_VERIFY, AttributeClass.KEY_SIGN_RECOVER, AttributeClass.KEY_VERIFY_RECOVER, AttributeClass.KEY_WRAP, AttributeClass.KEY_UNWRAP);
        public static final /* enum */ ItemClass PUBLIC_KEY = new ItemClass(15, AttributeClass.KEY_CLASS, AttributeClass.KEY_PRINT_NAME, AttributeClass.KEY_ALIAS, AttributeClass.KEY_PERMANENT, AttributeClass.KEY_PRIVATE, AttributeClass.KEY_MODIFIABLE, AttributeClass.KEY_LABEL, AttributeClass.KEY_APPLICATION_TAG, AttributeClass.KEY_KEY_CREATOR, AttributeClass.KEY_KEY_KYPE, AttributeClass.KEY_KEY_SIZE_IN_BITS, AttributeClass.KEY_EFFECTIVE_KEY_SIZE, AttributeClass.KEY_START_DATE, AttributeClass.KEY_END_DATE, AttributeClass.KEY_SENSITIVE, AttributeClass.KEY_ALWAYS_SENSITIVE, AttributeClass.KEY_EXTRACTABLE, AttributeClass.KEY_NEVER_EXTRACTABLE, AttributeClass.KEY_ENCRYPT, AttributeClass.DEY_DECRYPT, AttributeClass.KEY_DERIVE, AttributeClass.DEY_SIGN, AttributeClass.KEY_VERIFY, AttributeClass.KEY_SIGN_RECOVER, AttributeClass.KEY_VERIFY_RECOVER, AttributeClass.KEY_WRAP, AttributeClass.KEY_UNWRAP);
        public static final /* enum */ ItemClass PRIVATE_KEY = new ItemClass(16, AttributeClass.KEY_CLASS, AttributeClass.KEY_PRINT_NAME, AttributeClass.KEY_ALIAS, AttributeClass.KEY_PERMANENT, AttributeClass.KEY_PRIVATE, AttributeClass.KEY_MODIFIABLE, AttributeClass.KEY_LABEL, AttributeClass.KEY_APPLICATION_TAG, AttributeClass.KEY_KEY_CREATOR, AttributeClass.KEY_KEY_KYPE, AttributeClass.KEY_KEY_SIZE_IN_BITS, AttributeClass.KEY_EFFECTIVE_KEY_SIZE, AttributeClass.KEY_START_DATE, AttributeClass.KEY_END_DATE, AttributeClass.KEY_SENSITIVE, AttributeClass.KEY_ALWAYS_SENSITIVE, AttributeClass.KEY_EXTRACTABLE, AttributeClass.KEY_NEVER_EXTRACTABLE, AttributeClass.KEY_ENCRYPT, AttributeClass.DEY_DECRYPT, AttributeClass.KEY_DERIVE, AttributeClass.DEY_SIGN, AttributeClass.KEY_VERIFY, AttributeClass.KEY_SIGN_RECOVER, AttributeClass.KEY_VERIFY_RECOVER, AttributeClass.KEY_WRAP, AttributeClass.KEY_UNWRAP);
        public static final /* enum */ ItemClass SYMMETRIC_KEY = new ItemClass(17, AttributeClass.KEY_CLASS, AttributeClass.KEY_PRINT_NAME, AttributeClass.KEY_ALIAS, AttributeClass.KEY_PERMANENT, AttributeClass.KEY_PRIVATE, AttributeClass.KEY_MODIFIABLE, AttributeClass.KEY_LABEL, AttributeClass.KEY_APPLICATION_TAG, AttributeClass.KEY_KEY_CREATOR, AttributeClass.KEY_KEY_KYPE, AttributeClass.KEY_KEY_SIZE_IN_BITS, AttributeClass.KEY_EFFECTIVE_KEY_SIZE, AttributeClass.KEY_START_DATE, AttributeClass.KEY_END_DATE, AttributeClass.KEY_SENSITIVE, AttributeClass.KEY_ALWAYS_SENSITIVE, AttributeClass.KEY_EXTRACTABLE, AttributeClass.KEY_NEVER_EXTRACTABLE, AttributeClass.KEY_ENCRYPT, AttributeClass.DEY_DECRYPT, AttributeClass.KEY_DERIVE, AttributeClass.DEY_SIGN, AttributeClass.KEY_VERIFY, AttributeClass.KEY_SIGN_RECOVER, AttributeClass.KEY_VERIFY_RECOVER, AttributeClass.KEY_WRAP, AttributeClass.KEY_UNWRAP);
        public static final /* enum */ ItemClass ALL_KEY_ITEMS = new ItemClass(18, new AttributeClass[0]);
        public static final /* enum */ ItemClass INTERNET_PASSWORD = new ItemClass(1768842612, AttributeClass.LABEL, AttributeClass.DESCRIPTION, AttributeClass.CREATION_DATE, AttributeClass.MOD_DATE, AttributeClass.COMMENT, AttributeClass.CREATOR, AttributeClass.TYPE, AttributeClass.SCRIPT_CODE, AttributeClass.INVISIBLE, AttributeClass.NEGATIVE, AttributeClass.CUSTOM_ICON, AttributeClass.ACCOUNT, AttributeClass.SECURITY_DOMAIN, AttributeClass.SERVER, AttributeClass.AUTHENTICATION_TYPE, AttributeClass.PORT, AttributeClass.PATH, AttributeClass.PROTOCOL);
        public static final /* enum */ ItemClass GENERIC_PASSWORD = new ItemClass(1734700656, AttributeClass.LABEL, AttributeClass.DESCRIPTION, AttributeClass.CREATION_DATE, AttributeClass.MOD_DATE, AttributeClass.COMMENT, AttributeClass.CREATOR, AttributeClass.TYPE, AttributeClass.SCRIPT_CODE, AttributeClass.INVISIBLE, AttributeClass.NEGATIVE, AttributeClass.CUSTOM_ICON, AttributeClass.ACCOUNT, AttributeClass.SERVICE, AttributeClass.GENERIC);
        public static final /* enum */ ItemClass APPLE_SHARE_PASSWORD = new ItemClass(1634953328, AttributeClass.LABEL, AttributeClass.DESCRIPTION, AttributeClass.CREATION_DATE, AttributeClass.MOD_DATE, AttributeClass.COMMENT, AttributeClass.CREATOR, AttributeClass.TYPE, AttributeClass.SCRIPT_CODE, AttributeClass.INVISIBLE, AttributeClass.NEGATIVE, AttributeClass.CUSTOM_ICON, AttributeClass.ACCOUNT, AttributeClass.VOLUME, AttributeClass.ADDRESS, AttributeClass.SIGNATURE, AttributeClass.PROTOCOL);
        public static final /* enum */ ItemClass CERTIFICATE = new ItemClass(-2147479552, AttributeClass.LABEL, AttributeClass.CERTIFICATE_TYPE, AttributeClass.CERTIFICATE_ENCODING, AttributeClass.ALIAS);
        private final int tag;
        private final AttributeClass[] ids;
        private static final /* synthetic */ ItemClass[] $VALUES;

        public static ItemClass[] values() {
            return (ItemClass[])$VALUES.clone();
        }

        public static ItemClass valueOf(String name) {
            return Enum.valueOf(ItemClass.class, name);
        }

        static Option<ItemClass> lookup(int tag) {
            switch (tag) {
                case 10: {
                    assert (false);
                    return Option.some((Object)((Object)ANY_ITEM));
                }
                case 11: {
                    assert (false);
                    return Option.some((Object)((Object)CERT_ITEM));
                }
                case 12: {
                    assert (false);
                    return Option.some((Object)((Object)CRL_ITEM));
                }
                case 13: {
                    assert (false);
                    return Option.some((Object)((Object)POLICY_ITEM));
                }
                case 14: {
                    assert (false);
                    return Option.some((Object)((Object)GENERIC_ITEM));
                }
                case 15: {
                    return Option.some((Object)((Object)PUBLIC_KEY));
                }
                case 16: {
                    return Option.some((Object)((Object)PRIVATE_KEY));
                }
                case 17: {
                    return Option.some((Object)((Object)SYMMETRIC_KEY));
                }
                case 18: {
                    assert (false);
                    return Option.some((Object)((Object)ALL_KEY_ITEMS));
                }
                case 1768842612: {
                    return Option.some((Object)((Object)INTERNET_PASSWORD));
                }
                case 1734700656: {
                    return Option.some((Object)((Object)GENERIC_PASSWORD));
                }
                case 1634953328: {
                    return Option.some((Object)((Object)APPLE_SHARE_PASSWORD));
                }
                case -2147479552: {
                    return Option.some((Object)((Object)CERTIFICATE));
                }
            }
            return Option.none();
        }

        private ItemClass(int tag, AttributeClass ... ids) {
            this.tag = tag;
            this.ids = ids;
        }

        int getTag() {
            return this.tag;
        }

        public AttributeClass[] getAttributeClasses() {
            return (AttributeClass[])this.ids.clone();
        }

        static {
            $VALUES = new ItemClass[]{ANY_ITEM, CERT_ITEM, CRL_ITEM, POLICY_ITEM, GENERIC_ITEM, PUBLIC_KEY, PRIVATE_KEY, SYMMETRIC_KEY, ALL_KEY_ITEMS, INTERNET_PASSWORD, GENERIC_PASSWORD, APPLE_SHARE_PASSWORD, CERTIFICATE};
        }
    }

    public static interface Item {
        public ItemClass getItemClass() throws KeychainException;

        @Nullable
        public ByteBuffer getAttribute(AttributeClass var1) throws KeychainException;

        public void setAttribute(AttributeClass var1, @Nullable ByteBuffer var2) throws KeychainException;

        public Map<AttributeClass, ByteBuffer> getAttributeMap() throws KeychainException;

        public void putAttributeMap(Map<AttributeClass, ByteBuffer> var1) throws KeychainException;

        public ByteBuffer getSecret() throws KeychainException;

        public void setSecret(ByteBuffer var1) throws KeychainException;

        public void delete() throws KeychainException;
    }

    public static interface Visitor {
        public void visit(Item var1) throws KeychainException;
    }
}

