/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.audience;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.text.ComponentLike;

public final class Audiences {
    static final Collector<? super Audience, ?, ForwardingAudience> COLLECTOR = Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), audiences -> Audience.audience(List.copyOf(audiences)));

    private Audiences() {
    }

    public static Consumer<? super Audience> sendingMessage(ComponentLike message) {
        return audience -> audience.sendMessage(message);
    }

    static ResourcePackCallback unwrapCallback(Audience forwarding, Audience dest, ResourcePackCallback cb) {
        if (cb == ResourcePackCallback.noOp()) {
            return cb;
        }
        return (uuid, status, audience) -> cb.packEventReceived(uuid, status, audience == dest ? forwarding : audience);
    }
}

