/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.bossbar;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarImplementation;
import net.kyori.adventure.bossbar.BossBarViewer;
import net.kyori.adventure.bossbar.HackyBossBarPlatformBridge;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.Services;
import org.jspecify.annotations.Nullable;

final class BossBarImpl
extends HackyBossBarPlatformBridge
implements BossBar {
    private final List<BossBar.Listener> listeners = new CopyOnWriteArrayList<BossBar.Listener>();
    private Component name;
    private float progress;
    private BossBar.Color color;
    private BossBar.Overlay overlay;
    private final Set<BossBar.Flag> flags = EnumSet.noneOf(BossBar.Flag.class);
    @Nullable BossBarImplementation implementation;

    BossBarImpl(Component name, float progress, BossBar.Color color, BossBar.Overlay overlay) {
        this.name = Objects.requireNonNull(name, "name");
        this.progress = progress;
        this.color = Objects.requireNonNull(color, "color");
        this.overlay = Objects.requireNonNull(overlay, "overlay");
    }

    BossBarImpl(Component name, float progress, BossBar.Color color, BossBar.Overlay overlay, Set<BossBar.Flag> flags) {
        this(name, progress, color, overlay);
        this.flags.addAll(flags);
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public BossBar name(Component newName) {
        Objects.requireNonNull(newName, "name");
        Component oldName = this.name;
        this.name = newName;
        this.forEachListener(listener -> listener.bossBarNameChanged(this, oldName, newName));
        return this;
    }

    @Override
    public float progress() {
        return this.progress;
    }

    @Override
    public BossBar progress(float newProgress) {
        BossBarImpl.checkProgress(newProgress);
        float oldProgress = this.progress;
        if (newProgress != oldProgress) {
            this.progress = newProgress;
            this.forEachListener(listener -> listener.bossBarProgressChanged(this, oldProgress, newProgress));
        }
        return this;
    }

    static void checkProgress(float progress) {
        if (progress < 0.0f || progress > 1.0f) {
            throw new IllegalArgumentException("progress must be between 0.0 and 1.0, was " + progress);
        }
    }

    @Override
    public BossBar.Color color() {
        return this.color;
    }

    @Override
    public BossBar color(BossBar.Color newColor) {
        Objects.requireNonNull(newColor, "color");
        BossBar.Color oldColor = this.color;
        if (newColor != oldColor) {
            this.color = newColor;
            this.forEachListener(listener -> listener.bossBarColorChanged(this, oldColor, newColor));
        }
        return this;
    }

    @Override
    public BossBar.Overlay overlay() {
        return this.overlay;
    }

    @Override
    public BossBar overlay(BossBar.Overlay newOverlay) {
        Objects.requireNonNull(newOverlay, "overlay");
        BossBar.Overlay oldOverlay = this.overlay;
        if (newOverlay != oldOverlay) {
            this.overlay = newOverlay;
            this.forEachListener(listener -> listener.bossBarOverlayChanged(this, oldOverlay, newOverlay));
        }
        return this;
    }

    @Override
    public Set<BossBar.Flag> flags() {
        return Collections.unmodifiableSet(this.flags);
    }

    @Override
    public BossBar flags(Set<BossBar.Flag> newFlags) {
        if (newFlags.isEmpty() && !this.flags.isEmpty()) {
            EnumSet<BossBar.Flag> oldFlags = EnumSet.copyOf(this.flags);
            this.flags.clear();
            this.forEachListener(listener -> listener.bossBarFlagsChanged(this, Set.of(), oldFlags));
        } else if (!this.flags.equals(newFlags)) {
            EnumSet<BossBar.Flag> oldFlags = EnumSet.copyOf(this.flags);
            this.flags.clear();
            this.flags.addAll(newFlags);
            EnumSet<BossBar.Flag> added = EnumSet.copyOf(newFlags);
            added.removeIf(oldFlags::contains);
            EnumSet<BossBar.Flag> removed = EnumSet.copyOf(oldFlags);
            removed.removeIf(this.flags::contains);
            this.forEachListener(listener -> listener.bossBarFlagsChanged(this, added, removed));
        }
        return this;
    }

    @Override
    public boolean hasFlag(BossBar.Flag flag) {
        return this.flags.contains((Object)flag);
    }

    @Override
    public BossBar addFlag(BossBar.Flag flag) {
        return this.editFlags(flag, Set::add, BossBarImpl::onFlagsAdded);
    }

    @Override
    public BossBar removeFlag(BossBar.Flag flag) {
        return this.editFlags(flag, Set::remove, BossBarImpl::onFlagsRemoved);
    }

    private BossBar editFlags(BossBar.Flag flag, BiPredicate<Set<BossBar.Flag>, BossBar.Flag> predicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> onChange) {
        if (predicate.test(this.flags, flag)) {
            onChange.accept(this, Collections.singleton(flag));
        }
        return this;
    }

    @Override
    public BossBar addFlags(BossBar.Flag ... flags) {
        return this.editFlags(flags, Set::add, BossBarImpl::onFlagsAdded);
    }

    @Override
    public BossBar removeFlags(BossBar.Flag ... flags) {
        return this.editFlags(flags, Set::remove, BossBarImpl::onFlagsRemoved);
    }

    private BossBar editFlags(BossBar.Flag[] flags, BiPredicate<Set<BossBar.Flag>, BossBar.Flag> predicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> onChange) {
        if (flags.length == 0) {
            return this;
        }
        EnumSet<BossBar.Flag> changes = null;
        for (BossBar.Flag flag : flags) {
            if (!predicate.test(this.flags, flag)) continue;
            if (changes == null) {
                changes = EnumSet.noneOf(BossBar.Flag.class);
            }
            changes.add(flag);
        }
        if (changes != null) {
            onChange.accept(this, changes);
        }
        return this;
    }

    @Override
    public BossBar addFlags(Iterable<BossBar.Flag> flags) {
        return this.editFlags(flags, Set::add, BossBarImpl::onFlagsAdded);
    }

    @Override
    public BossBar removeFlags(Iterable<BossBar.Flag> flags) {
        return this.editFlags(flags, Set::remove, BossBarImpl::onFlagsRemoved);
    }

    private BossBar editFlags(Iterable<BossBar.Flag> flags, BiPredicate<Set<BossBar.Flag>, BossBar.Flag> predicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> onChange) {
        EnumSet<BossBar.Flag> changes = null;
        for (BossBar.Flag flag : flags) {
            if (!predicate.test(this.flags, flag)) continue;
            if (changes == null) {
                changes = EnumSet.noneOf(BossBar.Flag.class);
            }
            changes.add(flag);
        }
        if (changes != null) {
            onChange.accept(this, changes);
        }
        return this;
    }

    @Override
    public BossBar addListener(BossBar.Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public BossBar removeListener(BossBar.Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public Iterable<? extends BossBarViewer> viewers() {
        if (this.implementation != null) {
            return this.implementation.viewers();
        }
        return List.of();
    }

    private void forEachListener(Consumer<BossBar.Listener> consumer) {
        for (BossBar.Listener listener : this.listeners) {
            consumer.accept(listener);
        }
    }

    private static void onFlagsAdded(BossBarImpl bar, Set<BossBar.Flag> flagsAdded) {
        bar.forEachListener(listener -> listener.bossBarFlagsChanged(bar, flagsAdded, Set.of()));
    }

    private static void onFlagsRemoved(BossBarImpl bar, Set<BossBar.Flag> flagsRemoved) {
        bar.forEachListener(listener -> listener.bossBarFlagsChanged(bar, Set.of(), flagsRemoved));
    }

    public String toString() {
        return "BossBarImpl{listeners=" + String.valueOf(this.listeners) + ", name=" + String.valueOf(this.name) + ", progress=" + this.progress + ", color=" + String.valueOf((Object)this.color) + ", overlay=" + String.valueOf((Object)this.overlay) + ", flags=" + String.valueOf(this.flags) + "}";
    }

    static final class ImplementationAccessor {
        private static final Optional<BossBarImplementation.Provider> SERVICE = Services.service(BossBarImplementation.Provider.class);

        private ImplementationAccessor() {
        }

        static <I extends BossBarImplementation> I get(BossBar bar, Class<I> type) {
            BossBarImplementation implementation = ((BossBarImpl)bar).implementation;
            if (implementation == null) {
                ((BossBarImpl)bar).implementation = implementation = SERVICE.get().create(bar);
            }
            return (I)((BossBarImplementation)type.cast(implementation));
        }
    }
}

