/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.chat;

import java.util.Objects;
import net.kyori.adventure.chat.ChatTypeImpl;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public interface ChatType {
    public static final ChatType CHAT = new ChatTypeImpl(Key.key((String)"chat"));
    public static final ChatType SAY_COMMAND = new ChatTypeImpl(Key.key((String)"say_command"));
    public static final ChatType MSG_COMMAND_INCOMING = new ChatTypeImpl(Key.key((String)"msg_command_incoming"));
    public static final ChatType MSG_COMMAND_OUTGOING = new ChatTypeImpl(Key.key((String)"msg_command_outgoing"));
    public static final ChatType TEAM_MSG_COMMAND_INCOMING = new ChatTypeImpl(Key.key((String)"team_msg_command_incoming"));
    public static final ChatType TEAM_MSG_COMMAND_OUTGOING = new ChatTypeImpl(Key.key((String)"team_msg_command_outgoing"));
    public static final ChatType EMOTE_COMMAND = new ChatTypeImpl(Key.key((String)"emote_command"));

    public static ChatType chatType(Keyed key) {
        ChatType chatType;
        if (key instanceof ChatType) {
            ChatType ct = (ChatType)key;
            chatType = ct;
        } else {
            chatType = new ChatTypeImpl(Objects.requireNonNull(key, "key").key());
        }
        return chatType;
    }

    @Contract(value="_ -> new", pure=true)
    default public Bound bind(ComponentLike name) {
        return this.bind(name, null);
    }

    @Contract(value="_, _ -> new", pure=true)
    default public Bound bind(ComponentLike name, @Nullable ComponentLike target) {
        return new ChatTypeImpl.BoundImpl(this, Objects.requireNonNull(name.asComponent(), "name"), ComponentLike.unbox(target));
    }

    public @Nullable Key key();

    public static interface Bound {
        @Contract(pure=true)
        public ChatType type();

        @Contract(pure=true)
        public Component name();

        @Contract(pure=true)
        public @Nullable Component target();
    }
}

