/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.chat;

import java.time.Instant;
import net.kyori.adventure.chat.SignedMessageImpl;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public interface SignedMessage
extends Identified {
    @Contract(value="_ -> new", pure=true)
    public static Signature signature(byte[] signature) {
        return new SignedMessageImpl.SignatureImpl(signature);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static SignedMessage system(String message, @Nullable ComponentLike unsignedContent) {
        return new SignedMessageImpl(message, ComponentLike.unbox(unsignedContent));
    }

    @Contract(pure=true)
    public Instant timestamp();

    @Contract(pure=true)
    public long salt();

    @Contract(pure=true)
    public @Nullable Signature signature();

    @Contract(pure=true)
    public @Nullable Component unsignedContent();

    @Contract(pure=true)
    public String message();

    @Contract(pure=true)
    default public boolean isSystem() {
        return this.identity() == Identity.nil();
    }

    @Contract(pure=true)
    default public boolean canDelete() {
        return this.signature() != null;
    }

    public static sealed interface Signature
    permits SignedMessageImpl.SignatureImpl {
        @Contract(pure=true)
        public byte[] bytes();
    }
}

