/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.internal.properties;

import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.internal.properties.AdventurePropertiesImpl;
import net.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public final class AdventureProperties {
    public static final Property<Boolean> DEBUG = AdventureProperties.property("debug", Boolean::parseBoolean, false);
    public static final Property<String> DEFAULT_TRANSLATION_LOCALE = AdventureProperties.property("defaultTranslationLocale", Function.identity(), null);
    public static final Property<Boolean> SERVICE_LOAD_FAILURES_ARE_FATAL = AdventureProperties.property("serviceLoadFailuresAreFatal", Boolean::parseBoolean, Boolean.TRUE, false);
    public static final Property<Boolean> TEXT_WARN_WHEN_LEGACY_FORMATTING_DETECTED = AdventureProperties.property("text.warnWhenLegacyFormattingDetected", Boolean::parseBoolean, Boolean.FALSE);
    public static final Property<Integer> DEFAULT_FLATTENER_NESTING_LIMIT = AdventureProperties.property("defaultFlattenerNestingLimit", Integer::parseInt, -1);

    private AdventureProperties() {
    }

    public static <T> Property<T> property(String name, Function<String, T> parser, @Nullable T defaultValue) {
        return AdventureProperties.property(name, parser, defaultValue, true);
    }

    public static <T> Property<T> property(String name, Function<String, T> parser, @Nullable T defaultValue, boolean allowProviderDefaultOverride) {
        return AdventurePropertiesImpl.property(name, parser, defaultValue, allowProviderDefaultOverride);
    }

    @ApiStatus.Internal
    @ApiStatus.NonExtendable
    public static interface Property<T> {
        public @Nullable T value();

        default public T valueOr(T defaultValue) {
            T value = this.value();
            return value == null ? Objects.requireNonNull(defaultValue, "defaultValue") : value;
        }
    }

    @PlatformAPI
    @ApiStatus.Internal
    public static interface DefaultOverrideProvider {
        public <T> @Nullable T overrideDefault(Property<T> var1, @Nullable T var2);
    }
}

