/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;

record BookImpl(Component title, Component author, List<Component> pages) implements Book
{
    BookImpl(Component title, Component author, List<Component> pages) {
        this.title = Objects.requireNonNull(title, "title");
        this.author = Objects.requireNonNull(author, "author");
        this.pages = List.copyOf((Collection)Objects.requireNonNull(pages, "pages"));
    }

    @Override
    public Book title(Component title) {
        return new BookImpl(Objects.requireNonNull(title, "title"), this.author, this.pages);
    }

    @Override
    public Book author(Component author) {
        return new BookImpl(this.title, Objects.requireNonNull(author, "author"), this.pages);
    }

    @Override
    public Book pages(List<Component> pages) {
        return new BookImpl(this.title, this.author, new ArrayList<Component>((Collection)Objects.requireNonNull(pages, "pages")));
    }

    @Override
    public Book.Builder toBuilder() {
        return new BuilderImpl().title(this.title).author(this.author).pages(this.pages);
    }

    @Override
    public Book asBook() {
        return this;
    }

    static final class BuilderImpl
    implements Book.Builder {
        private Component title = Component.empty();
        private Component author = Component.empty();
        private final List<Component> pages = new ArrayList<Component>();

        BuilderImpl() {
        }

        @Override
        public Book.Builder title(Component title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @Override
        public Book.Builder author(Component author) {
            this.author = Objects.requireNonNull(author, "author");
            return this;
        }

        @Override
        public Book.Builder addPage(Component page) {
            this.pages.add(Objects.requireNonNull(page, "page"));
            return this;
        }

        @Override
        public Book.Builder pages(Collection<Component> pages) {
            this.pages.addAll(Objects.requireNonNull(pages, "pages"));
            return this;
        }

        @Override
        public Book.Builder pages(Component ... pages) {
            Collections.addAll(this.pages, pages);
            return this;
        }

        @Override
        public Book build() {
            return new BookImpl(this.title, this.author, List.copyOf(this.pages));
        }
    }
}

