/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.pointer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.pointer.Pointer;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.pointer.PointersSupplier;
import org.jspecify.annotations.Nullable;

record PointersSupplierImpl<T>(@Nullable PointersSupplier<? super T> parent, Map<Pointer<?>, Function<T, ?>> resolvers) implements PointersSupplier<T>
{
    @Override
    public Pointers view(T instance) {
        return new ForwardingPointers<T>(instance, this);
    }

    @Override
    public <P> boolean supports(Pointer<P> pointer) {
        if (this.resolvers.containsKey(Objects.requireNonNull(pointer, "pointer"))) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.supports(pointer);
    }

    @Override
    public <P> @Nullable Function<? super T, P> resolver(Pointer<P> pointer) {
        Function<T, ?> resolver = this.resolvers.get(Objects.requireNonNull(pointer, "pointer"));
        if (resolver != null) {
            return resolver;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.resolver(pointer);
    }

    record ForwardingPointers<U>(U instance, PointersSupplierImpl<U> supplier) implements Pointers
    {
        @Override
        public <T> Optional<T> get(Pointer<T> pointer) {
            PointersSupplier parent;
            Function<Object, Object> resolver = this.supplier.resolvers.get(Objects.requireNonNull(pointer, "pointer"));
            if (resolver == null && (parent = this.supplier.parent) != null) {
                resolver = parent.resolver(pointer);
            }
            return Optional.ofNullable(resolver).map(r -> r.apply(this.instance));
        }

        @Override
        public <T> boolean supports(Pointer<T> pointer) {
            return this.supplier.supports(pointer);
        }

        @Override
        public Pointers.Builder toBuilder() {
            Pointers.Builder builder = this.supplier.parent == null ? Pointers.builder() : (Pointers.Builder)this.supplier.parent.view(this.instance).toBuilder();
            for (Map.Entry entry : this.supplier.resolvers.entrySet()) {
                builder.withDynamic(entry.getKey(), () -> ((Function)entry.getValue()).apply(this.instance));
            }
            return builder;
        }
    }

    static final class BuilderImpl<T>
    implements PointersSupplier.Builder<T> {
        private @Nullable PointersSupplier<? super T> parent = null;
        private final Map<Pointer<?>, Function<T, ?>> resolvers = new HashMap();

        BuilderImpl() {
        }

        @Override
        public PointersSupplier.Builder<T> parent(@Nullable PointersSupplier<? super T> parent) {
            this.parent = parent;
            return this;
        }

        @Override
        public <P> PointersSupplier.Builder<T> resolving(Pointer<P> pointer, Function<T, P> resolver) {
            this.resolvers.put(pointer, resolver);
            return this;
        }

        @Override
        public PointersSupplier<T> build() {
            return new PointersSupplierImpl<T>(this.parent, Map.copyOf(this.resolvers));
        }
    }
}

