/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.resource;

import java.net.URI;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.resource.ResourcePackInfoImpl;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import org.jetbrains.annotations.Contract;

public sealed interface ResourcePackInfo
extends ResourcePackInfoLike
permits ResourcePackInfoImpl {
    public static ResourcePackInfo resourcePackInfo(UUID id, URI uri, String hash) {
        return new ResourcePackInfoImpl(id, uri, hash);
    }

    public static Builder resourcePackInfo() {
        return new ResourcePackInfoImpl.BuilderImpl();
    }

    public UUID id();

    public URI uri();

    public String hash();

    @Override
    default public ResourcePackInfo asResourcePackInfo() {
        return this;
    }

    public static sealed interface Builder
    extends AbstractBuilder<ResourcePackInfo>,
    ResourcePackInfoLike
    permits ResourcePackInfoImpl.BuilderImpl {
        @Contract(value="_ -> this")
        public Builder id(UUID var1);

        @Contract(value="_ -> this")
        public Builder uri(URI var1);

        @Contract(value="_ -> this")
        public Builder hash(String var1);

        @Override
        public ResourcePackInfo build();

        default public CompletableFuture<ResourcePackInfo> computeHashAndBuild() {
            return this.computeHashAndBuild(ForkJoinPool.commonPool());
        }

        public CompletableFuture<ResourcePackInfo> computeHashAndBuild(Executor var1);

        @Override
        default public ResourcePackInfo asResourcePackInfo() {
            return this.build();
        }
    }
}

