/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.resource;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.resource.ResourcePackRequestImpl;
import net.kyori.adventure.resource.ResourcePackRequestLike;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public sealed interface ResourcePackRequest
extends ResourcePackRequestLike
permits ResourcePackRequestImpl {
    public static ResourcePackRequest addingRequest(ResourcePackInfoLike first, ResourcePackInfoLike ... others) {
        return (ResourcePackRequest)ResourcePackRequest.resourcePackRequest().packs(first, others).replace(false).build();
    }

    public static Builder resourcePackRequest() {
        return new ResourcePackRequestImpl.BuilderImpl();
    }

    public static Builder resourcePackRequest(ResourcePackRequest existing) {
        return new ResourcePackRequestImpl.BuilderImpl(Objects.requireNonNull(existing, "existing"));
    }

    public List<ResourcePackInfo> packs();

    public ResourcePackRequest packs(Iterable<? extends ResourcePackInfoLike> var1);

    public ResourcePackCallback callback();

    public ResourcePackRequest callback(ResourcePackCallback var1);

    public boolean replace();

    public ResourcePackRequest replace(boolean var1);

    public boolean required();

    public @Nullable Component prompt();

    @Override
    default public ResourcePackRequest asResourcePackRequest() {
        return this;
    }

    public static sealed interface Builder
    extends AbstractBuilder<ResourcePackRequest>,
    ResourcePackRequestLike
    permits ResourcePackRequestImpl.BuilderImpl {
        @Contract(value="_, _ -> this")
        public Builder packs(ResourcePackInfoLike var1, ResourcePackInfoLike ... var2);

        @Contract(value="_ -> this")
        public Builder packs(Iterable<? extends ResourcePackInfoLike> var1);

        @Contract(value="_ -> this")
        public Builder callback(ResourcePackCallback var1);

        @Contract(value="_ -> this")
        public Builder replace(boolean var1);

        @Contract(value="_ -> this")
        public Builder required(boolean var1);

        @Contract(value="_ -> this")
        public Builder prompt(@Nullable Component var1);

        @Override
        default public ResourcePackRequest asResourcePackRequest() {
            return (ResourcePackRequest)this.build();
        }
    }
}

