/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.resource;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.MonkeyBars;
import org.jspecify.annotations.Nullable;

record ResourcePackRequestImpl(List<ResourcePackInfo> packs, ResourcePackCallback callback, boolean replace, boolean required, @Nullable Component prompt) implements ResourcePackRequest
{
    @Override
    public ResourcePackRequest packs(Iterable<? extends ResourcePackInfoLike> packs) {
        if (this.packs.equals(packs)) {
            return this;
        }
        return new ResourcePackRequestImpl(MonkeyBars.toUnmodifiableList(ResourcePackInfoLike::asResourcePackInfo, packs), this.callback, this.replace, this.required, this.prompt);
    }

    @Override
    public ResourcePackRequest callback(ResourcePackCallback cb) {
        if (cb == this.callback) {
            return this;
        }
        return new ResourcePackRequestImpl(this.packs, Objects.requireNonNull(cb, "cb"), this.replace, this.required, this.prompt);
    }

    @Override
    public ResourcePackRequest replace(boolean replace) {
        if (replace == this.replace) {
            return this;
        }
        return new ResourcePackRequestImpl(this.packs, this.callback, replace, this.required, this.prompt);
    }

    static final class BuilderImpl
    implements ResourcePackRequest.Builder {
        private List<ResourcePackInfo> packs;
        private ResourcePackCallback cb;
        private boolean replace;
        private boolean required;
        private @Nullable Component prompt;

        BuilderImpl() {
            this.packs = List.of();
            this.cb = ResourcePackCallback.noOp();
            this.replace = false;
        }

        BuilderImpl(ResourcePackRequest req) {
            this.packs = req.packs();
            this.cb = req.callback();
            this.replace = req.replace();
            this.required = req.required();
            this.prompt = req.prompt();
        }

        @Override
        public ResourcePackRequest.Builder packs(ResourcePackInfoLike first, ResourcePackInfoLike ... others) {
            this.packs = MonkeyBars.nonEmptyArrayToList(ResourcePackInfoLike::asResourcePackInfo, first, others);
            return this;
        }

        @Override
        public ResourcePackRequest.Builder packs(Iterable<? extends ResourcePackInfoLike> packs) {
            this.packs = MonkeyBars.toUnmodifiableList(ResourcePackInfoLike::asResourcePackInfo, packs);
            return this;
        }

        @Override
        public ResourcePackRequest.Builder callback(ResourcePackCallback cb) {
            this.cb = Objects.requireNonNull(cb, "cb");
            return this;
        }

        @Override
        public ResourcePackRequest.Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        @Override
        public ResourcePackRequest.Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public ResourcePackRequest.Builder prompt(@Nullable Component prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public ResourcePackRequest build() {
            return new ResourcePackRequestImpl(this.packs, this.cb, this.replace, this.required, this.prompt);
        }
    }
}

