/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.sound;

import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.util.ShadyPines;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

abstract sealed class SoundImpl
implements Sound {
    static final Sound.Emitter EMITTER_SELF = new Sound.Emitter(){

        public String toString() {
            return "SelfSoundEmitter";
        }
    };
    private final Sound.Source source;
    private final float volume;
    private final float pitch;
    private final OptionalLong seed;
    private @Nullable SoundStop stop;

    SoundImpl(Sound.Source source, float volume, float pitch, OptionalLong seed) {
        this.source = source;
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }

    @Override
    public Sound.Source source() {
        return this.source;
    }

    @Override
    public float volume() {
        return this.volume;
    }

    @Override
    public float pitch() {
        return this.pitch;
    }

    @Override
    public OptionalLong seed() {
        return this.seed;
    }

    @Override
    public SoundStop asStop() {
        if (this.stop == null) {
            this.stop = SoundStop.namedOnSource(this.name(), this.source());
        }
        return this.stop;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SoundImpl)) {
            return false;
        }
        SoundImpl that = (SoundImpl)other;
        return this.name().equals((Object)that.name()) && this.source == that.source && ShadyPines.equals(this.volume, that.volume) && ShadyPines.equals(this.pitch, that.pitch) && this.seed.equals(that.seed);
    }

    public int hashCode() {
        int result = this.name().hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + Float.hashCode(this.volume);
        result = 31 * result + Float.hashCode(this.pitch);
        result = 31 * result + this.seed.hashCode();
        return result;
    }

    static final class Lazy
    extends SoundImpl {
        final Supplier<? extends Sound.Type> supplier;

        Lazy(Supplier<? extends Sound.Type> supplier, Sound.Source source, float volume, float pitch, OptionalLong seed) {
            super(source, volume, pitch, seed);
            this.supplier = supplier;
        }

        @Override
        public Key name() {
            return this.supplier.get().key();
        }
    }

    static final class Eager
    extends SoundImpl {
        final Key name;

        Eager(Key name, Sound.Source source, float volume, float pitch, OptionalLong seed) {
            super(source, volume, pitch, seed);
            this.name = name;
        }

        @Override
        public Key name() {
            return this.name;
        }
    }

    static final class BuilderImpl
    implements Sound.Builder {
        private static final float DEFAULT_VOLUME = 1.0f;
        private static final float DEFAULT_PITCH = 1.0f;
        private @Nullable Key eagerType;
        private @Nullable Supplier<? extends Sound.Type> lazyType;
        private Sound.Source source = Sound.Source.MASTER;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private OptionalLong seed = OptionalLong.empty();

        BuilderImpl() {
        }

        BuilderImpl(Sound existing) {
            if (existing instanceof Eager) {
                Eager eager = (Eager)existing;
                this.type(eager.name);
            } else if (existing instanceof Lazy) {
                Lazy lazy = (Lazy)existing;
                this.type(lazy.supplier);
            } else {
                throw new IllegalArgumentException("Unknown sound type " + String.valueOf(existing) + ", must be Eager or Lazy");
            }
            this.source(existing.source()).volume(existing.volume()).pitch(existing.pitch()).seed(existing.seed());
        }

        @Override
        public Sound.Builder type(Key type) {
            this.eagerType = Objects.requireNonNull(type, "type");
            this.lazyType = null;
            return this;
        }

        @Override
        public Sound.Builder type(Sound.Type type) {
            this.eagerType = Objects.requireNonNull(Objects.requireNonNull(type, "type").key(), "type.key()");
            this.lazyType = null;
            return this;
        }

        @Override
        public Sound.Builder type(Supplier<? extends Sound.Type> typeSupplier) {
            this.lazyType = Objects.requireNonNull(typeSupplier, "typeSupplier");
            this.eagerType = null;
            return this;
        }

        @Override
        public Sound.Builder source(Sound.Source source) {
            this.source = Objects.requireNonNull(source, "source");
            return this;
        }

        @Override
        public Sound.Builder source(Sound.Source.Provider source) {
            return this.source(source.soundSource());
        }

        @Override
        public Sound.Builder volume(@Range(from=0L, to=0x7FFFFFFFL) float volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public Sound.Builder pitch(@Range(from=-1L, to=1L) float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        public Sound.Builder seed(long seed) {
            this.seed = OptionalLong.of(seed);
            return this;
        }

        @Override
        public Sound.Builder seed(OptionalLong seed) {
            this.seed = Objects.requireNonNull(seed, "seed");
            return this;
        }

        @Override
        public Sound build() {
            if (this.eagerType != null) {
                return new Eager(this.eagerType, this.source, this.volume, this.pitch, this.seed);
            }
            if (this.lazyType != null) {
                return new Lazy(this.lazyType, this.source, this.volume, this.pitch, this.seed);
            }
            throw new IllegalStateException("A sound type must be provided to build a sound");
        }
    }
}

