/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.sound;

import java.util.Objects;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStopImpl;
import org.jspecify.annotations.Nullable;

public sealed interface SoundStop
permits SoundStopImpl {
    public static SoundStop all() {
        return SoundStopImpl.ALL;
    }

    public static SoundStop named(Key sound) {
        Objects.requireNonNull(sound, "sound");
        return new SoundStopImpl(sound, null);
    }

    public static SoundStop named(Sound.Type sound) {
        Objects.requireNonNull(sound, "sound");
        return new SoundStopImpl(sound.key(), null);
    }

    public static SoundStop named(Supplier<? extends Sound.Type> sound) {
        Objects.requireNonNull(sound, "sound");
        return new SoundStopImpl(sound.get().key(), null);
    }

    public static SoundStop source(Sound.Source source) {
        Objects.requireNonNull(source, "source");
        return new SoundStopImpl(null, source);
    }

    public static SoundStop namedOnSource(Key sound, Sound.Source source) {
        Objects.requireNonNull(sound, "sound");
        Objects.requireNonNull(source, "source");
        return new SoundStopImpl(sound, source);
    }

    public static SoundStop namedOnSource(Sound.Type sound, Sound.Source source) {
        Objects.requireNonNull(sound, "sound");
        return SoundStop.namedOnSource(sound.key(), source);
    }

    public static SoundStop namedOnSource(Supplier<? extends Sound.Type> sound, Sound.Source source) {
        Objects.requireNonNull(sound, "sound");
        Objects.requireNonNull(source, "source");
        return new SoundStopImpl(sound.get().key(), source);
    }

    public @Nullable Key sound();

    public @Nullable Sound.Source source();
}

