/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.AbstractNBTComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.KeybindComponentImpl;
import net.kyori.adventure.text.ObjectComponentImpl;
import net.kyori.adventure.text.ScoreComponentImpl;
import net.kyori.adventure.text.SelectorComponentImpl;
import net.kyori.adventure.text.TextComponentImpl;
import net.kyori.adventure.text.TranslatableComponentImpl;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ARGBLike;
import org.jspecify.annotations.Nullable;

abstract sealed class AbstractComponentBuilder<C extends Component, B extends ComponentBuilder<C, B>>
implements ComponentBuilder<C, B>
permits AbstractNBTComponentBuilder, KeybindComponentImpl.BuilderImpl, ObjectComponentImpl.BuilderImpl, ScoreComponentImpl.BuilderImpl, SelectorComponentImpl.BuilderImpl, TextComponentImpl.BuilderImpl, TranslatableComponentImpl.BuilderImpl {
    protected List<Component> children = List.of();
    private @Nullable Style style;
    private @Nullable Style.Builder styleBuilder;

    protected AbstractComponentBuilder() {
    }

    protected AbstractComponentBuilder(C component) {
        List<Component> children = component.children();
        if (!children.isEmpty()) {
            this.children = new ArrayList<Component>(children);
        }
        if (component.hasStyling()) {
            this.style = component.style();
        }
    }

    @Override
    public B append(Component component) {
        if (component == Component.empty()) {
            return (B)this;
        }
        this.prepareChildren();
        this.children.add(Objects.requireNonNull(component, "component"));
        return (B)this;
    }

    @Override
    public B append(Component ... components) {
        return this.append((ComponentLike[])components);
    }

    @Override
    public B append(ComponentLike ... components) {
        Objects.requireNonNull(components, "components");
        boolean prepared = false;
        for (ComponentLike componentLike : components) {
            Component component = Objects.requireNonNull(componentLike, "components[?]").asComponent();
            if (component == Component.empty()) continue;
            if (!prepared) {
                this.prepareChildren();
                prepared = true;
            }
            this.children.add(Objects.requireNonNull(component, "components[?]"));
        }
        return (B)this;
    }

    @Override
    public B append(Iterable<? extends ComponentLike> components) {
        Objects.requireNonNull(components, "components");
        boolean prepared = false;
        for (ComponentLike componentLike : components) {
            Component component = Objects.requireNonNull(componentLike, "components[?]").asComponent();
            if (component == Component.empty()) continue;
            if (!prepared) {
                this.prepareChildren();
                prepared = true;
            }
            this.children.add(Objects.requireNonNull(component, "components[?]"));
        }
        return (B)this;
    }

    private void prepareChildren() {
        if (this.children.isEmpty()) {
            this.children = new ArrayList<Component>();
        }
    }

    @Override
    public B applyDeep(Consumer<? super ComponentBuilder<?, ?>> consumer) {
        this.apply(consumer);
        if (this.children.isEmpty()) {
            return (B)this;
        }
        ListIterator<Component> it = this.children.listIterator();
        while (it.hasNext()) {
            ComponentBuilder<?, ?> childBuilder = it.next().toBuilder();
            childBuilder.applyDeep(consumer);
            it.set((Component)childBuilder.build());
        }
        return (B)this;
    }

    @Override
    public B mapChildren(Function<Component, ? extends Component> function) {
        if (this.children.isEmpty()) {
            return (B)this;
        }
        ListIterator<Component> it = this.children.listIterator();
        while (it.hasNext()) {
            Component mappedChild;
            Component child = it.next();
            if (child == (mappedChild = Objects.requireNonNull(function.apply(child), "mappedChild"))) continue;
            it.set(mappedChild);
        }
        return (B)this;
    }

    @Override
    public B mapChildrenDeep(Function<Component, ? extends Component> function) {
        if (this.children.isEmpty()) {
            return (B)this;
        }
        ListIterator<Component> it = this.children.listIterator();
        while (it.hasNext()) {
            Component child = it.next();
            Component mappedChild = Objects.requireNonNull(function.apply(child), "mappedChild");
            if (mappedChild.children().isEmpty()) {
                if (child == mappedChild) continue;
                it.set(mappedChild);
                continue;
            }
            ComponentBuilder<?, ?> builder = mappedChild.toBuilder();
            builder.mapChildrenDeep(function);
            it.set((Component)builder.build());
        }
        return (B)this;
    }

    @Override
    public List<Component> children() {
        return List.copyOf(this.children);
    }

    @Override
    public B style(Style style) {
        this.style = style;
        this.styleBuilder = null;
        return (B)this;
    }

    @Override
    public B style(Consumer<Style.Builder> consumer) {
        consumer.accept(this.styleBuilder());
        return (B)this;
    }

    @Override
    public B font(@Nullable Key font) {
        this.styleBuilder().font(font);
        return (B)this;
    }

    @Override
    public B color(@Nullable TextColor color) {
        this.styleBuilder().color(color);
        return (B)this;
    }

    @Override
    public B colorIfAbsent(@Nullable TextColor color) {
        this.styleBuilder().colorIfAbsent(color);
        return (B)this;
    }

    @Override
    public B shadowColor(@Nullable ARGBLike argb) {
        this.styleBuilder().shadowColor(argb);
        return (B)this;
    }

    @Override
    public B shadowColorIfAbsent(@Nullable ARGBLike argb) {
        this.styleBuilder().shadowColorIfAbsent(argb);
        return (B)this;
    }

    @Override
    public B decoration(TextDecoration decoration, TextDecoration.State state) {
        this.styleBuilder().decoration(decoration, state);
        return (B)this;
    }

    @Override
    public B decorationIfAbsent(TextDecoration decoration, TextDecoration.State state) {
        this.styleBuilder().decorationIfAbsent(decoration, state);
        return (B)this;
    }

    @Override
    public B clickEvent(@Nullable ClickEvent<?> event) {
        this.styleBuilder().clickEvent((ClickEvent)event);
        return (B)this;
    }

    @Override
    public B hoverEvent(@Nullable HoverEventSource<?> source) {
        this.styleBuilder().hoverEvent((HoverEventSource)source);
        return (B)this;
    }

    @Override
    public B insertion(@Nullable String insertion) {
        this.styleBuilder().insertion(insertion);
        return (B)this;
    }

    @Override
    public B mergeStyle(Component that, Set<Style.Merge> merges) {
        Style thatStyle = Objects.requireNonNull(that, "that").style();
        if (thatStyle.isEmpty() && merges.isEmpty()) {
            return (B)this;
        }
        this.styleBuilder().merge(thatStyle, merges);
        return (B)this;
    }

    @Override
    public B resetStyle() {
        this.style = null;
        this.styleBuilder = null;
        return (B)this;
    }

    private Style.Builder styleBuilder() {
        if (this.styleBuilder == null) {
            if (this.style != null) {
                this.styleBuilder = this.style.toBuilder();
                this.style = null;
            } else {
                this.styleBuilder = Style.style();
            }
        }
        return this.styleBuilder;
    }

    protected final boolean hasStyle() {
        return this.styleBuilder != null || this.style != null;
    }

    protected Style buildStyle() {
        if (this.styleBuilder != null) {
            return this.styleBuilder.build();
        }
        if (this.style != null) {
            return this.style;
        }
        return Style.empty();
    }
}

