/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.Objects;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.BlockNBTComponentImpl;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponentImpl;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.StorageNBTComponentImpl;
import org.jspecify.annotations.Nullable;

abstract sealed class AbstractNBTComponentBuilder<C extends NBTComponent<C>, B extends NBTComponentBuilder<C, B>>
extends AbstractComponentBuilder<C, B>
implements NBTComponentBuilder<C, B>
permits BlockNBTComponentImpl.BuilderImpl, EntityNBTComponentImpl.BuilderImpl, StorageNBTComponentImpl.BuilderImpl {
    protected @Nullable String nbtPath;
    protected boolean interpret = false;
    protected @Nullable Component separator;

    AbstractNBTComponentBuilder() {
    }

    AbstractNBTComponentBuilder(C component) {
        super(component);
        this.nbtPath = component.nbtPath();
        this.interpret = component.interpret();
        this.separator = component.separator();
    }

    @Override
    public B nbtPath(String nbtPath) {
        this.nbtPath = Objects.requireNonNull(nbtPath, "nbtPath");
        return (B)this;
    }

    @Override
    public B interpret(boolean interpret) {
        this.interpret = interpret;
        return (B)this;
    }

    @Override
    public B separator(@Nullable ComponentLike separator) {
        this.separator = ComponentLike.unbox(separator);
        return (B)this;
    }
}

