/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.BlockNBTComponentImpl;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentCompaction;
import net.kyori.adventure.text.ComponentIterator;
import net.kyori.adventure.text.ComponentIteratorFlag;
import net.kyori.adventure.text.ComponentIteratorType;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.EntityNBTComponentImpl;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.JoinConfigurationImpl;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.KeybindComponentImpl;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.ObjectComponentImpl;
import net.kyori.adventure.text.ScopedComponent;
import net.kyori.adventure.text.ScopedComponentOverrideNotRequired;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.ScoreComponentImpl;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.SelectorComponentImpl;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.StorageNBTComponentImpl;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextComponentImpl;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.TextReplacementConfigImpl;
import net.kyori.adventure.text.TextReplacementRenderer;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslatableComponentImpl;
import net.kyori.adventure.text.VirtualComponent;
import net.kyori.adventure.text.VirtualComponentImpl;
import net.kyori.adventure.text.VirtualComponentRenderer;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.StyleGetter;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.translation.Translatable;
import net.kyori.adventure.util.ARGBLike;
import net.kyori.adventure.util.ForwardingIterator;
import net.kyori.adventure.util.MonkeyBars;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public sealed interface Component
extends ComponentBuilderApplicable,
ComponentLike,
HoverEventSource<Component>,
StyleGetter,
StyleSetter<Component>
permits NBTComponent, ScopedComponent {
    public static final BiPredicate<? super Component, ? super Component> EQUALS = Objects::equals;
    public static final BiPredicate<? super Component, ? super Component> EQUALS_IDENTITY = (a, b) -> a == b;
    public static final Predicate<? super Component> IS_NOT_EMPTY = component -> component != Component.empty();

    public static TextComponent empty() {
        return TextComponentImpl.EMPTY;
    }

    public static TextComponent newline() {
        return TextComponentImpl.NEWLINE;
    }

    public static TextComponent space() {
        return TextComponentImpl.SPACE;
    }

    @Contract(pure=true)
    public static Component join(JoinConfiguration.Builder configBuilder, ComponentLike ... components) {
        return Component.join(configBuilder, List.of(components));
    }

    @Contract(pure=true)
    public static Component join(JoinConfiguration.Builder configBuilder, Iterable<? extends ComponentLike> components) {
        return JoinConfigurationImpl.join((JoinConfiguration)configBuilder.build(), components);
    }

    @Contract(pure=true)
    public static Component join(JoinConfiguration config, ComponentLike ... components) {
        return Component.join(config, List.of(components));
    }

    @Contract(pure=true)
    public static Component join(JoinConfiguration config, Iterable<? extends ComponentLike> components) {
        return JoinConfigurationImpl.join(config, components);
    }

    public static Collector<Component, ? extends ComponentBuilder<?, ?>, Component> toComponent() {
        return Component.toComponent(Component.empty());
    }

    public static Collector<Component, ? extends ComponentBuilder<?, ?>, Component> toComponent(Component separator) {
        return Collector.of(Component::text, (builder, add) -> {
            if (separator != Component.empty() && !builder.children().isEmpty()) {
                builder.append(separator);
            }
            builder.append((Component)add);
        }, (a, b) -> {
            List<Component> aChildren = a.children();
            TextComponent.Builder ret = (TextComponent.Builder)Component.text().append(aChildren);
            if (!aChildren.isEmpty()) {
                ret.append(separator);
            }
            ret.append(b.children());
            return ret;
        }, ComponentBuilder::build, new Collector.Characteristics[0]);
    }

    @Contract(pure=true)
    public static BlockNBTComponent.Builder blockNBT() {
        return new BlockNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static BlockNBTComponent blockNBT(Consumer<? super BlockNBTComponent.Builder> consumer) {
        return (BlockNBTComponent)AbstractBuilder.configureAndBuild(Component.blockNBT(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static BlockNBTComponent blockNBT(String nbtPath, BlockNBTComponent.Pos pos) {
        return Component.blockNBT(nbtPath, false, pos);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static BlockNBTComponent blockNBT(String nbtPath, boolean interpret, BlockNBTComponent.Pos pos) {
        return Component.blockNBT(nbtPath, interpret, null, pos);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static BlockNBTComponent blockNBT(String nbtPath, boolean interpret, @Nullable ComponentLike separator, BlockNBTComponent.Pos pos) {
        return BlockNBTComponentImpl.create(List.of(), Style.empty(), nbtPath, interpret, separator, pos);
    }

    @Contract(pure=true)
    public static EntityNBTComponent.Builder entityNBT() {
        return new EntityNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static EntityNBTComponent entityNBT(Consumer<? super EntityNBTComponent.Builder> consumer) {
        return (EntityNBTComponent)AbstractBuilder.configureAndBuild(Component.entityNBT(), consumer);
    }

    @Contract(value="_, _ -> new")
    public static EntityNBTComponent entityNBT(String nbtPath, String selector) {
        return (EntityNBTComponent)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath(nbtPath)).selector(selector).build();
    }

    @Contract(pure=true)
    public static KeybindComponent.Builder keybind() {
        return new KeybindComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static KeybindComponent keybind(Consumer<? super KeybindComponent.Builder> consumer) {
        return (KeybindComponent)AbstractBuilder.configureAndBuild(Component.keybind(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static KeybindComponent keybind(String keybind) {
        return Component.keybind(keybind, Style.empty());
    }

    @Contract(value="_ -> new", pure=true)
    public static KeybindComponent keybind(KeybindComponent.KeybindLike keybind) {
        return Component.keybind(Objects.requireNonNull(keybind, "keybind").asKeybind(), Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static KeybindComponent keybind(String keybind, Style style) {
        return KeybindComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), keybind);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static KeybindComponent keybind(KeybindComponent.KeybindLike keybind, Style style) {
        return KeybindComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), Objects.requireNonNull(keybind, "keybind").asKeybind());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static KeybindComponent keybind(String keybind, @Nullable TextColor color) {
        return Component.keybind(keybind, Style.style(color));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static KeybindComponent keybind(KeybindComponent.KeybindLike keybind, @Nullable TextColor color) {
        return Component.keybind(Objects.requireNonNull(keybind, "keybind").asKeybind(), Style.style(color));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static KeybindComponent keybind(String keybind, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.keybind(keybind, Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static KeybindComponent keybind(KeybindComponent.KeybindLike keybind, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.keybind(Objects.requireNonNull(keybind, "keybind").asKeybind(), Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static KeybindComponent keybind(String keybind, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.keybind(keybind, Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static KeybindComponent keybind(KeybindComponent.KeybindLike keybind, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.keybind(Objects.requireNonNull(keybind, "keybind").asKeybind(), Style.style(color, decorations));
    }

    @Contract(pure=true)
    public static ObjectComponent.Builder object() {
        return new ObjectComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static ObjectComponent object(Consumer<? super ObjectComponent.Builder> consumer) {
        return (ObjectComponent)AbstractBuilder.configureAndBuild(Component.object(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static ObjectComponent object(ObjectContents objectContents) {
        return ObjectComponentImpl.create(List.of(), Style.empty(), objectContents);
    }

    @Contract(pure=true)
    public static ScoreComponent.Builder score() {
        return new ScoreComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static ScoreComponent score(Consumer<? super ScoreComponent.Builder> consumer) {
        return (ScoreComponent)AbstractBuilder.configureAndBuild(Component.score(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static ScoreComponent score(String name, String objective) {
        return Component.score(name, objective, null);
    }

    @ApiStatus.Obsolete
    @Contract(value="_, _, _ -> new", pure=true)
    public static ScoreComponent score(String name, String objective, @Nullable String value) {
        return ScoreComponentImpl.create(List.of(), Style.empty(), name, objective, value);
    }

    @Contract(pure=true)
    public static SelectorComponent.Builder selector() {
        return new SelectorComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static SelectorComponent selector(Consumer<? super SelectorComponent.Builder> consumer) {
        return (SelectorComponent)AbstractBuilder.configureAndBuild(Component.selector(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static SelectorComponent selector(String pattern) {
        return Component.selector(pattern, null);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static SelectorComponent selector(String pattern, @Nullable ComponentLike separator) {
        return SelectorComponentImpl.create(List.of(), Style.empty(), pattern, separator);
    }

    @Contract(pure=true)
    public static StorageNBTComponent.Builder storageNBT() {
        return new StorageNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static StorageNBTComponent storageNBT(Consumer<? super StorageNBTComponent.Builder> consumer) {
        return (StorageNBTComponent)AbstractBuilder.configureAndBuild(Component.storageNBT(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static StorageNBTComponent storageNBT(String nbtPath, Key storage) {
        return Component.storageNBT(nbtPath, false, storage);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static StorageNBTComponent storageNBT(String nbtPath, boolean interpret, Key storage) {
        return Component.storageNBT(nbtPath, interpret, null, storage);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static StorageNBTComponent storageNBT(String nbtPath, boolean interpret, @Nullable ComponentLike separator, Key storage) {
        return StorageNBTComponentImpl.create(List.of(), Style.empty(), nbtPath, interpret, separator, storage);
    }

    @Contract(pure=true)
    public static TextComponent.Builder text() {
        return new TextComponentImpl.BuilderImpl();
    }

    public static TextComponent textOfChildren(ComponentLike ... components) {
        if (components.length == 0) {
            return Component.empty();
        }
        return TextComponentImpl.create(List.of(components), Style.empty(), "");
    }

    @Contract(value="_ -> new")
    public static TextComponent text(Consumer<? super TextComponent.Builder> consumer) {
        return (TextComponent)AbstractBuilder.configureAndBuild(Component.text(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static TextComponent text(String content) {
        if (content.isEmpty()) {
            return Component.empty();
        }
        return Component.text(content, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(String content, Style style) {
        return TextComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), content);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(String content, @Nullable TextColor color) {
        return Component.text(content, Style.style(color));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(String content, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(content, Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(String content, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.text(content, Style.style(color, decorations));
    }

    @Contract(value="_ -> new", pure=true)
    public static TextComponent text(boolean value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(boolean value, Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(boolean value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(boolean value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(boolean value, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(pure=true)
    public static TextComponent text(char value) {
        if (value == '\n') {
            return Component.newline();
        }
        if (value == ' ') {
            return Component.space();
        }
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(char value, Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(char value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(char value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(char value, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static TextComponent text(double value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(double value, Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(double value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(double value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(double value, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static TextComponent text(float value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(float value, Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(float value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(float value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(float value, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static TextComponent text(int value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(int value, Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(int value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(int value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(int value, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static TextComponent text(long value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(long value, Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextComponent text(long value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(long value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TextComponent text(long value, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <C> VirtualComponent virtual(Class<C> contextType, VirtualComponentRenderer<C> renderer) {
        Objects.requireNonNull(contextType, "context type");
        Objects.requireNonNull(renderer, "renderer");
        return VirtualComponentImpl.createVirtual(contextType, renderer);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <C> VirtualComponent virtual(Class<C> contextType, VirtualComponentRenderer<C> renderer, Style style) {
        Objects.requireNonNull(contextType, "context type");
        Objects.requireNonNull(renderer, "renderer");
        return VirtualComponentImpl.createVirtual(contextType, renderer, List.of(), style);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <C> VirtualComponent virtual(Class<C> contextType, VirtualComponentRenderer<C> renderer, StyleBuilderApplicable ... style) {
        Objects.requireNonNull(contextType, "context type");
        Objects.requireNonNull(renderer, "renderer");
        return VirtualComponentImpl.createVirtual(contextType, renderer, List.of(), Style.style(style));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <C> VirtualComponent virtual(Class<C> contextType, VirtualComponentRenderer<C> renderer, Iterable<StyleBuilderApplicable> style) {
        Objects.requireNonNull(contextType, "context type");
        Objects.requireNonNull(renderer, "renderer");
        return VirtualComponentImpl.createVirtual(contextType, renderer, List.of(), Style.style(style));
    }

    @Contract(pure=true)
    public static TranslatableComponent.Builder translatable() {
        return new TranslatableComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static TranslatableComponent translatable(Consumer<? super TranslatableComponent.Builder> consumer) {
        return (TranslatableComponent)AbstractBuilder.configureAndBuild(Component.translatable(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static TranslatableComponent translatable(String key) {
        return Component.translatable(key, Style.empty());
    }

    @Contract(value="_ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback) {
        return Component.translatable(key, fallback, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, Style style) {
        return TranslatableComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), key, null, List.of());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, Style style) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), style);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback, Style style) {
        return TranslatableComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), key, fallback, List.of());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback, Style style) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, style);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback, StyleBuilderApplicable ... style) {
        return Component.translatable(Objects.requireNonNull(key, "key"), fallback, Style.style(style));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback, Iterable<StyleBuilderApplicable> style) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, Style.style(style));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback, ComponentLike ... args) {
        return Component.translatable(key, fallback, Style.empty(), args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback, ComponentLike ... args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback, Style style, ComponentLike ... args) {
        return TranslatableComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), key, fallback, Objects.requireNonNull(args, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback, Style style, ComponentLike ... args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, style, args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback, Style style, List<? extends ComponentLike> args) {
        return TranslatableComponentImpl.create(List.of(), style, key, fallback, Objects.requireNonNull(args, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback, Style style, List<? extends ComponentLike> args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, style, args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback, List<? extends ComponentLike> args, Iterable<StyleBuilderApplicable> style) {
        return TranslatableComponentImpl.create(List.of(), Style.style(style), key, fallback, Objects.requireNonNull(args, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback, List<? extends ComponentLike> args, Iterable<StyleBuilderApplicable> style) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, args, style);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable String fallback, List<? extends ComponentLike> args, StyleBuilderApplicable ... style) {
        return TranslatableComponentImpl.create(List.of(), Style.style(style), key, fallback, Objects.requireNonNull(args, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable String fallback, List<? extends ComponentLike> args, StyleBuilderApplicable ... style) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), fallback, args, style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable TextColor color) {
        return Component.translatable(key, Style.style(color));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable TextColor color) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.translatable(key, Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.translatable(key, Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable TextColor color, Set<TextDecoration> decorations) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), color, decorations);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, ComponentLike ... args) {
        return Component.translatable(key, Style.empty(), args);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, ComponentLike ... args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, Style style, ComponentLike ... args) {
        return TranslatableComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), key, null, Objects.requireNonNull(args, "args"));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, Style style, ComponentLike ... args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), style, args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable TextColor color, ComponentLike ... args) {
        return Component.translatable(key, Style.style(color), args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable TextColor color, ComponentLike ... args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), color, args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable TextColor color, Set<TextDecoration> decorations, ComponentLike ... args) {
        return Component.translatable(key, Style.style(color, decorations), args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable TextColor color, Set<TextDecoration> decorations, ComponentLike ... args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), color, decorations, args);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, List<? extends ComponentLike> args) {
        return TranslatableComponentImpl.create(List.of(), Style.empty(), key, null, Objects.requireNonNull(args, "args"));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, List<? extends ComponentLike> args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, Style style, List<? extends ComponentLike> args) {
        return TranslatableComponentImpl.create(List.of(), Objects.requireNonNull(style, "style"), key, null, Objects.requireNonNull(args, "args"));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, Style style, List<? extends ComponentLike> args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), style, args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable TextColor color, List<? extends ComponentLike> args) {
        return Component.translatable(key, Style.style(color), args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable TextColor color, List<? extends ComponentLike> args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), color, args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(String key, @Nullable TextColor color, Set<TextDecoration> decorations, List<? extends ComponentLike> args) {
        return Component.translatable(key, Style.style(color, decorations), args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(Translatable translatable, @Nullable TextColor color, Set<TextDecoration> decorations, List<? extends ComponentLike> args) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), color, decorations, args);
    }

    public @Unmodifiable List<Component> children();

    @Contract(pure=true)
    public Component children(List<? extends ComponentLike> var1);

    default public boolean contains(Component that) {
        return this.contains(that, EQUALS_IDENTITY);
    }

    default public boolean contains(Component that, BiPredicate<? super Component, ? super Component> equals) {
        if (equals.test(this, that)) {
            return true;
        }
        for (Component child : this.children()) {
            if (!child.contains(that, equals)) continue;
            return true;
        }
        @Nullable HoverEvent<?> hoverEvent = this.hoverEvent();
        if (hoverEvent != null) {
            Object value = hoverEvent.value();
            Component component = null;
            if (value instanceof Component) {
                component = (Component)hoverEvent.value();
            } else if (value instanceof HoverEvent.ShowEntity) {
                HoverEvent.ShowEntity se = (HoverEvent.ShowEntity)value;
                component = se.name();
            }
            if (component != null) {
                if (equals.test(that, component)) {
                    return true;
                }
                for (Component child : component.children()) {
                    if (!child.contains(that, equals)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Contract(pure=true)
    default public Component append(Component component) {
        return this.append((ComponentLike)component);
    }

    default public Component append(ComponentLike like) {
        Objects.requireNonNull(like, "like");
        Component component = like.asComponent();
        Objects.requireNonNull(component, "component");
        if (component == Component.empty()) {
            return this;
        }
        List<Component> oldChildren = this.children();
        return this.children(MonkeyBars.addOne(oldChildren, component));
    }

    @Contract(pure=true)
    default public Component append(ComponentBuilder<?, ?> builder) {
        return this.append((Component)builder.build());
    }

    @Contract(pure=true)
    default public Component appendNewline() {
        return this.append(Component.newline());
    }

    @Contract(pure=true)
    default public Component appendSpace() {
        return this.append(Component.space());
    }

    @Contract(pure=true)
    default public Component append(ComponentLike ... components) {
        if (components.length == 0) {
            return this;
        }
        ArrayList<Component> newChildren = new ArrayList<Component>(components.length + this.children().size());
        newChildren.addAll(this.children());
        Collections.addAll(newChildren, components);
        return this.children(newChildren);
    }

    @Contract(pure=true)
    default public Component append(List<? extends ComponentLike> components) {
        if (components.isEmpty()) {
            return this;
        }
        if (this.children().isEmpty()) {
            return this.children(components);
        }
        ArrayList<? extends ComponentLike> newChildren = new ArrayList<ComponentLike>(components.size() + this.children().size());
        newChildren.addAll(this.children());
        newChildren.addAll(components);
        return this.children(newChildren);
    }

    @Contract(pure=true)
    default public Component applyFallbackStyle(Style style) {
        Objects.requireNonNull(style, "style");
        return this.style(this.style().merge(style, Style.Merge.Strategy.IF_ABSENT_ON_TARGET));
    }

    @Contract(pure=true)
    default public Component applyFallbackStyle(StyleBuilderApplicable ... style) {
        return this.applyFallbackStyle(Style.style(style));
    }

    public Style style();

    @Contract(pure=true)
    public Component style(Style var1);

    @Contract(pure=true)
    default public Component style(Consumer<Style.Builder> consumer) {
        return this.style(this.style().edit(consumer));
    }

    @Contract(pure=true)
    default public Component style(Consumer<Style.Builder> consumer, Style.Merge.Strategy strategy) {
        return this.style(this.style().edit(consumer, strategy));
    }

    @Contract(pure=true)
    default public Component style(Style.Builder style) {
        return this.style(style.build());
    }

    @Contract(pure=true)
    default public Component mergeStyle(Component that) {
        return this.mergeStyle(that, Style.Merge.all());
    }

    @Contract(pure=true)
    default public Component mergeStyle(Component that, Style.Merge ... merges) {
        return this.mergeStyle(that, Style.Merge.merges(merges));
    }

    @Contract(pure=true)
    default public Component mergeStyle(Component that, Set<Style.Merge> merges) {
        return this.style(this.style().merge(that.style(), merges));
    }

    @Override
    default public @Nullable Key font() {
        return this.style().font();
    }

    @Override
    default public Component font(@Nullable Key key) {
        return this.style(this.style().font(key));
    }

    @Override
    default public @Nullable TextColor color() {
        return this.style().color();
    }

    @Override
    default public @Nullable ShadowColor shadowColor() {
        return this.style().shadowColor();
    }

    @Override
    @Contract(pure=true)
    default public Component color(@Nullable TextColor color) {
        return this.style(this.style().color(color));
    }

    @Override
    @Contract(pure=true)
    default public Component colorIfAbsent(@Nullable TextColor color) {
        if (this.color() == null) {
            return this.color(color);
        }
        return this;
    }

    @Override
    @Contract(pure=true)
    default public Component shadowColor(@Nullable ARGBLike argb) {
        return this.style((Style)this.style().shadowColor(argb));
    }

    @Override
    @Contract(pure=true)
    default public Component shadowColorIfAbsent(@Nullable ARGBLike argb) {
        if (this.shadowColor() == null) {
            return this.shadowColor(argb);
        }
        return this;
    }

    @Override
    default public boolean hasDecoration(TextDecoration decoration) {
        return StyleGetter.super.hasDecoration(decoration);
    }

    @Override
    @Contract(pure=true)
    default public Component decorate(TextDecoration decoration) {
        return (Component)StyleSetter.super.decorate(decoration);
    }

    @Override
    default public TextDecoration.State decoration(TextDecoration decoration) {
        return this.style().decoration(decoration);
    }

    @Override
    @Contract(pure=true)
    default public Component decoration(TextDecoration decoration, boolean flag) {
        return (Component)StyleSetter.super.decoration(decoration, flag);
    }

    @Override
    @Contract(pure=true)
    default public Component decoration(TextDecoration decoration, TextDecoration.State state) {
        return this.style(this.style().decoration(decoration, state));
    }

    @Override
    default public Component decorationIfAbsent(TextDecoration decoration, TextDecoration.State state) {
        Objects.requireNonNull(state, "state");
        TextDecoration.State oldState = this.decoration(decoration);
        if (oldState == TextDecoration.State.NOT_SET) {
            return this.style(this.style().decoration(decoration, state));
        }
        return this;
    }

    @Override
    default public Map<TextDecoration, TextDecoration.State> decorations() {
        return this.style().decorations();
    }

    @Override
    @Contract(pure=true)
    default public Component decorations(Map<TextDecoration, TextDecoration.State> decorations) {
        return this.style((Style)this.style().decorations((Map)decorations));
    }

    @Override
    default public @Nullable ClickEvent<?> clickEvent() {
        return this.style().clickEvent();
    }

    @Override
    @Contract(pure=true)
    default public Component clickEvent(@Nullable ClickEvent<?> event) {
        return this.style((Style)this.style().clickEvent((ClickEvent)event));
    }

    @Override
    default public @Nullable HoverEvent<?> hoverEvent() {
        return this.style().hoverEvent();
    }

    @Override
    @Contract(pure=true)
    default public Component hoverEvent(@Nullable HoverEventSource<?> source) {
        return this.style((Style)this.style().hoverEvent((HoverEventSource)source));
    }

    @Override
    default public @Nullable String insertion() {
        return this.style().insertion();
    }

    @Override
    @Contract(pure=true)
    default public Component insertion(@Nullable String insertion) {
        return this.style(this.style().insertion(insertion));
    }

    default public boolean hasStyling() {
        return !this.style().isEmpty();
    }

    @ScopedComponentOverrideNotRequired
    @Contract(pure=true)
    default public Component replaceText(Consumer<TextReplacementConfig.Builder> configurer) {
        Objects.requireNonNull(configurer, "configurer");
        return this.replaceText((TextReplacementConfig)AbstractBuilder.configureAndBuild(TextReplacementConfig.builder(), configurer));
    }

    @ScopedComponentOverrideNotRequired
    @Contract(pure=true)
    default public Component replaceText(TextReplacementConfig config) {
        Objects.requireNonNull(config, "replacement");
        return TextReplacementRenderer.INSTANCE.render(this, ((TextReplacementConfigImpl)config).createState());
    }

    @ScopedComponentOverrideNotRequired
    default public Component compact() {
        return this.compact(null);
    }

    @ScopedComponentOverrideNotRequired
    default public Component compact(@Nullable Style parentStyle) {
        return ComponentCompaction.compact(this, parentStyle);
    }

    default public Iterable<Component> iterable(ComponentIteratorType type, ComponentIteratorFlag ... flags) {
        return this.iterable(type, flags == null ? Set.of() : MonkeyBars.enumSet(ComponentIteratorFlag.class, (Enum[])flags));
    }

    default public Iterable<Component> iterable(ComponentIteratorType type, Set<ComponentIteratorFlag> flags) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(flags, "flags");
        return new ForwardingIterator<Component>(() -> this.iterator(type, flags), () -> this.spliterator(type, flags));
    }

    default public Iterator<Component> iterator(ComponentIteratorType type, ComponentIteratorFlag ... flags) {
        return this.iterator(type, flags == null ? Set.of() : MonkeyBars.enumSet(ComponentIteratorFlag.class, (Enum[])flags));
    }

    default public Iterator<Component> iterator(ComponentIteratorType type, Set<ComponentIteratorFlag> flags) {
        return new ComponentIterator(this, Objects.requireNonNull(type, "type"), Objects.requireNonNull(flags, "flags"));
    }

    default public Spliterator<Component> spliterator(ComponentIteratorType type, ComponentIteratorFlag ... flags) {
        return this.spliterator(type, flags == null ? Set.of() : MonkeyBars.enumSet(ComponentIteratorFlag.class, (Enum[])flags));
    }

    default public Spliterator<Component> spliterator(ComponentIteratorType type, Set<ComponentIteratorFlag> flags) {
        return Spliterators.spliteratorUnknownSize(this.iterator(type, flags), 1296);
    }

    public ComponentBuilder<?, ?> toBuilder();

    @Override
    default public void componentBuilderApply(ComponentBuilder<?, ?> component) {
        component.append(this);
    }

    @Override
    default public Component asComponent() {
        return this;
    }

    @Override
    default public HoverEvent<Component> asHoverEvent(UnaryOperator<Component> op) {
        return HoverEvent.showText((Component)op.apply(this));
    }
}

