/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.Deque;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentIteratorFlag;
import net.kyori.adventure.text.ComponentIteratorType;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.HoverEvent;

final class ComponentIteratorTypeImpl {
    private ComponentIteratorTypeImpl() {
    }

    static final class BreadthFirst
    implements ComponentIteratorType {
        static final ComponentIteratorType INSTANCE = new BreadthFirst();

        BreadthFirst() {
        }

        @Override
        public void populate(Component component, Deque<Component> deque, Set<ComponentIteratorFlag> flags) {
            HoverEvent<?> hoverEvent;
            if (flags.contains((Object)ComponentIteratorFlag.INCLUDE_TRANSLATABLE_COMPONENT_ARGUMENTS) && component instanceof TranslatableComponent) {
                TranslatableComponent tc = (TranslatableComponent)component;
                for (TranslationArgument argument : tc.arguments()) {
                    deque.add(argument.asComponent());
                }
            }
            if ((hoverEvent = component.hoverEvent()) != null) {
                HoverEvent.Action<?> action = hoverEvent.action();
                if (flags.contains((Object)ComponentIteratorFlag.INCLUDE_HOVER_SHOW_ENTITY_NAME) && action == HoverEvent.Action.SHOW_ENTITY) {
                    Component name = ((HoverEvent.ShowEntity)hoverEvent.value()).name();
                    if (name != null) {
                        deque.addLast(name);
                    }
                } else if (flags.contains((Object)ComponentIteratorFlag.INCLUDE_HOVER_SHOW_TEXT_COMPONENT) && action == HoverEvent.Action.SHOW_TEXT) {
                    deque.addLast((Component)hoverEvent.value());
                }
            }
            deque.addAll(component.children());
        }
    }

    static final class DepthFirst
    implements ComponentIteratorType {
        static final ComponentIteratorType INSTANCE = new DepthFirst();

        DepthFirst() {
        }

        @Override
        public void populate(Component component, Deque<Component> deque, Set<ComponentIteratorFlag> flags) {
            HoverEvent<?> hoverEvent;
            int i;
            if (flags.contains((Object)ComponentIteratorFlag.INCLUDE_TRANSLATABLE_COMPONENT_ARGUMENTS) && component instanceof TranslatableComponent) {
                TranslatableComponent translatable = (TranslatableComponent)component;
                List<TranslationArgument> args = translatable.arguments();
                for (i = args.size() - 1; i >= 0; --i) {
                    deque.addFirst(((ComponentLike)args.get(i)).asComponent());
                }
            }
            if ((hoverEvent = component.hoverEvent()) != null) {
                HoverEvent.Action<?> action = hoverEvent.action();
                if (flags.contains((Object)ComponentIteratorFlag.INCLUDE_HOVER_SHOW_ENTITY_NAME) && action == HoverEvent.Action.SHOW_ENTITY) {
                    deque.addFirst(((HoverEvent.ShowEntity)hoverEvent.value()).name());
                } else if (flags.contains((Object)ComponentIteratorFlag.INCLUDE_HOVER_SHOW_TEXT_COMPONENT) && action == HoverEvent.Action.SHOW_TEXT) {
                    deque.addFirst((Component)hoverEvent.value());
                }
            }
            List<Component> children = component.children();
            for (i = children.size() - 1; i >= 0; --i) {
                deque.addFirst(children.get(i));
            }
        }
    }
}

