/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.AbstractNBTComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

record EntityNBTComponentImpl(List<Component> children, Style style, String nbtPath, boolean interpret, Component separator, String selector) implements EntityNBTComponent
{
    static EntityNBTComponent create(List<? extends ComponentLike> children, Style style, String nbtPath, boolean interpret, @Nullable ComponentLike separator, String selector) {
        return new EntityNBTComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(nbtPath, "nbtPath"), interpret, ComponentLike.unbox(separator), Objects.requireNonNull(selector, "selector"));
    }

    @Override
    public EntityNBTComponent nbtPath(String nbtPath) {
        if (Objects.equals(this.nbtPath, nbtPath)) {
            return this;
        }
        return EntityNBTComponentImpl.create(this.children, this.style, nbtPath, this.interpret, this.separator, this.selector);
    }

    @Override
    public EntityNBTComponent interpret(boolean interpret) {
        if (this.interpret == interpret) {
            return this;
        }
        return EntityNBTComponentImpl.create(this.children, this.style, this.nbtPath, interpret, this.separator, this.selector);
    }

    @Override
    public EntityNBTComponent separator(@Nullable ComponentLike separator) {
        return EntityNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, separator, this.selector);
    }

    @Override
    public EntityNBTComponent selector(String selector) {
        if (Objects.equals(this.selector, selector)) {
            return this;
        }
        return EntityNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, this.separator, selector);
    }

    @Override
    public EntityNBTComponent children(List<? extends ComponentLike> children) {
        return EntityNBTComponentImpl.create(children, this.style, this.nbtPath, this.interpret, this.separator, this.selector);
    }

    @Override
    public EntityNBTComponent style(Style style) {
        return EntityNBTComponentImpl.create(this.children, style, this.nbtPath, this.interpret, this.separator, this.selector);
    }

    @Override
    public EntityNBTComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractNBTComponentBuilder<EntityNBTComponent, EntityNBTComponent.Builder>
    implements EntityNBTComponent.Builder {
        private @Nullable String selector;

        BuilderImpl() {
        }

        BuilderImpl(EntityNBTComponent component) {
            super(component);
            this.selector = component.selector();
        }

        @Override
        public EntityNBTComponent.Builder selector(String selector) {
            this.selector = Objects.requireNonNull(selector, "selector");
            return this;
        }

        @Override
        public EntityNBTComponent build() {
            if (this.nbtPath == null) {
                throw new IllegalStateException("nbt path must be set");
            }
            if (this.selector == null) {
                throw new IllegalStateException("selector must be set");
            }
            return EntityNBTComponentImpl.create(this.children, this.buildStyle(), this.nbtPath, this.interpret, this.separator, this.selector);
        }
    }
}

