/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

record KeybindComponentImpl(List<Component> children, Style style, String keybind) implements KeybindComponent
{
    static KeybindComponent create(List<? extends ComponentLike> children, Style style, String keybind) {
        return new KeybindComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(keybind, "keybind"));
    }

    @Override
    public KeybindComponent keybind(String keybind) {
        if (Objects.equals(this.keybind, keybind)) {
            return this;
        }
        return KeybindComponentImpl.create(this.children, this.style, keybind);
    }

    @Override
    public KeybindComponent children(List<? extends ComponentLike> children) {
        return KeybindComponentImpl.create(children, this.style, this.keybind);
    }

    @Override
    public KeybindComponent style(Style style) {
        return KeybindComponentImpl.create(this.children, style, this.keybind);
    }

    @Override
    public KeybindComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<KeybindComponent, KeybindComponent.Builder>
    implements KeybindComponent.Builder {
        private @Nullable String keybind;

        BuilderImpl() {
        }

        BuilderImpl(KeybindComponent component) {
            super(component);
            this.keybind = component.keybind();
        }

        @Override
        public KeybindComponent.Builder keybind(String keybind) {
            this.keybind = Objects.requireNonNull(keybind, "keybind");
            return this;
        }

        @Override
        public KeybindComponent build() {
            if (this.keybind == null) {
                throw new IllegalStateException("keybind must be set");
            }
            return KeybindComponentImpl.create(this.children, this.buildStyle(), this.keybind);
        }
    }
}

