/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.object.ObjectContents;

record ObjectComponentImpl(List<Component> children, Style style, ObjectContents contents) implements ObjectComponent
{
    static ObjectComponentImpl create(List<? extends ComponentLike> children, Style style, ObjectContents objectContents) {
        return new ObjectComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(objectContents, "contents"));
    }

    @Override
    public ObjectComponent contents(ObjectContents contents) {
        return ObjectComponentImpl.create(this.children, this.style, contents);
    }

    @Override
    public ObjectComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    public ObjectComponent children(List<? extends ComponentLike> children) {
        return ObjectComponentImpl.create(children, this.style, this.contents);
    }

    @Override
    public ObjectComponent style(Style style) {
        return ObjectComponentImpl.create(this.children, style, this.contents);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<ObjectComponent, ObjectComponent.Builder>
    implements ObjectComponent.Builder {
        private ObjectContents objectContents;

        BuilderImpl() {
        }

        BuilderImpl(ObjectComponent component) {
            super(component);
            this.objectContents = component.contents();
        }

        @Override
        public ObjectComponent.Builder contents(ObjectContents objectContents) {
            this.objectContents = Objects.requireNonNull(objectContents, "contents");
            return this;
        }

        @Override
        public ObjectComponent build() {
            if (this.objectContents == null) {
                throw new IllegalStateException("contents must be set");
            }
            return ObjectComponentImpl.create(this.children, this.buildStyle(), this.objectContents);
        }
    }
}

