/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

record SelectorComponentImpl(List<Component> children, Style style, String pattern, @Nullable Component separator) implements SelectorComponent
{
    static SelectorComponent create(List<? extends ComponentLike> children, Style style, String pattern, @Nullable ComponentLike separator) {
        return new SelectorComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(pattern, "pattern"), ComponentLike.unbox(separator));
    }

    @Override
    public SelectorComponent pattern(String pattern) {
        if (Objects.equals(this.pattern, pattern)) {
            return this;
        }
        return SelectorComponentImpl.create(this.children, this.style, pattern, this.separator);
    }

    @Override
    public SelectorComponent separator(@Nullable ComponentLike separator) {
        return SelectorComponentImpl.create(this.children, this.style, this.pattern, separator);
    }

    @Override
    public SelectorComponent children(List<? extends ComponentLike> children) {
        return SelectorComponentImpl.create(children, this.style, this.pattern, this.separator);
    }

    @Override
    public SelectorComponent style(Style style) {
        return SelectorComponentImpl.create(this.children, style, this.pattern, this.separator);
    }

    @Override
    public SelectorComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<SelectorComponent, SelectorComponent.Builder>
    implements SelectorComponent.Builder {
        private @Nullable String pattern;
        private @Nullable Component separator;

        BuilderImpl() {
        }

        BuilderImpl(SelectorComponent component) {
            super(component);
            this.pattern = component.pattern();
            this.separator = component.separator();
        }

        @Override
        public SelectorComponent.Builder pattern(String pattern) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            return this;
        }

        @Override
        public SelectorComponent.Builder separator(@Nullable ComponentLike separator) {
            this.separator = ComponentLike.unbox(separator);
            return this;
        }

        @Override
        public SelectorComponent build() {
            if (this.pattern == null) {
                throw new IllegalStateException("pattern must be set");
            }
            return SelectorComponentImpl.create(this.children, this.buildStyle(), this.pattern, this.separator);
        }
    }
}

