/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.AbstractNBTComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

record StorageNBTComponentImpl(List<Component> children, Style style, String nbtPath, boolean interpret, @Nullable Component separator, Key storage) implements StorageNBTComponent
{
    static StorageNBTComponent create(List<? extends ComponentLike> children, Style style, String nbtPath, boolean interpret, @Nullable ComponentLike separator, Key storage) {
        return new StorageNBTComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(nbtPath, "nbtPath"), interpret, ComponentLike.unbox(separator), Objects.requireNonNull(storage, "storage"));
    }

    @Override
    public StorageNBTComponent nbtPath(String nbtPath) {
        if (Objects.equals(this.nbtPath, nbtPath)) {
            return this;
        }
        return StorageNBTComponentImpl.create(this.children, this.style, nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    public StorageNBTComponent interpret(boolean interpret) {
        if (this.interpret == interpret) {
            return this;
        }
        return StorageNBTComponentImpl.create(this.children, this.style, this.nbtPath, interpret, this.separator, this.storage);
    }

    @Override
    public StorageNBTComponent separator(@Nullable ComponentLike separator) {
        return StorageNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, separator, this.storage);
    }

    @Override
    public StorageNBTComponent storage(Key storage) {
        if (Objects.equals(this.storage, storage)) {
            return this;
        }
        return StorageNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, this.separator, storage);
    }

    @Override
    public StorageNBTComponent children(List<? extends ComponentLike> children) {
        return StorageNBTComponentImpl.create(children, this.style, this.nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    public StorageNBTComponent style(Style style) {
        return StorageNBTComponentImpl.create(this.children, style, this.nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    public StorageNBTComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractNBTComponentBuilder<StorageNBTComponent, StorageNBTComponent.Builder>
    implements StorageNBTComponent.Builder {
        private @Nullable Key storage;

        BuilderImpl() {
        }

        BuilderImpl(StorageNBTComponent component) {
            super(component);
            this.storage = component.storage();
        }

        @Override
        public StorageNBTComponent.Builder storage(Key storage) {
            this.storage = Objects.requireNonNull(storage, "storage");
            return this;
        }

        @Override
        public StorageNBTComponent build() {
            if (this.nbtPath == null) {
                throw new IllegalStateException("nbt path must be set");
            }
            if (this.storage == null) {
                throw new IllegalStateException("storage must be set");
            }
            return StorageNBTComponentImpl.create(this.children, this.buildStyle(), this.nbtPath, this.interpret, this.separator, this.storage);
        }
    }
}

