/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.internal.properties.AdventureProperties;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.LegacyFormattingDetected;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.VirtualComponentImpl;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.util.Nag;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

sealed class TextComponentImpl
implements TextComponent
permits VirtualComponentImpl {
    private static final boolean WARN_WHEN_LEGACY_FORMATTING_DETECTED = Boolean.TRUE.equals(AdventureProperties.TEXT_WARN_WHEN_LEGACY_FORMATTING_DETECTED.value());
    @VisibleForTesting
    static final char SECTION_CHAR = '\u00a7';
    static final TextComponent EMPTY = TextComponentImpl.createDirect("");
    static final TextComponent NEWLINE = TextComponentImpl.createDirect("\n");
    static final TextComponent SPACE = TextComponentImpl.createDirect(" ");
    private final String content;
    private final List<Component> children;
    private final Style style;

    static TextComponent create(List<? extends ComponentLike> children, Style style, String content) {
        List<Component> filteredChildren = ComponentLike.asComponents(children, IS_NOT_EMPTY);
        if (filteredChildren.isEmpty() && style.isEmpty() && content.isEmpty()) {
            return Component.empty();
        }
        return new TextComponentImpl(filteredChildren, Objects.requireNonNull(style, "style"), Objects.requireNonNull(content, "content"));
    }

    TextComponent create0(List<? extends ComponentLike> children, Style style, String content) {
        return TextComponentImpl.create(children, style, content);
    }

    private static TextComponent createDirect(String content) {
        return new TextComponentImpl(List.of(), Style.empty(), content);
    }

    TextComponentImpl(List<Component> children, Style style, String content) {
        LegacyFormattingDetected nag;
        this.content = content;
        this.children = children;
        this.style = style;
        if (WARN_WHEN_LEGACY_FORMATTING_DETECTED && (nag = this.warnWhenLegacyFormattingDetected()) != null) {
            Nag.print(nag);
        }
    }

    @VisibleForTesting
    final @Nullable LegacyFormattingDetected warnWhenLegacyFormattingDetected() {
        if (this.content.indexOf(167) != -1) {
            return new LegacyFormattingDetected(this);
        }
        return null;
    }

    @Override
    public @Unmodifiable List<Component> children() {
        return this.children;
    }

    @Override
    public Style style() {
        return this.style;
    }

    @Override
    public String content() {
        return this.content;
    }

    @Override
    public TextComponent content(String content) {
        if (Objects.equals(this.content, content)) {
            return this;
        }
        return this.create0(this.children, this.style, content);
    }

    @Override
    public TextComponent children(List<? extends ComponentLike> children) {
        return this.create0(children, this.style, this.content);
    }

    @Override
    public TextComponent style(Style style) {
        return this.create0(this.children, style, this.content);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextComponentImpl)) {
            return false;
        }
        TextComponentImpl that = (TextComponentImpl)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.children, that.children) && Objects.equals(this.style, that.style);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.content.hashCode();
        result = 31 * result + this.children.hashCode();
        result = 31 * result + this.style.hashCode();
        return result;
    }

    public String toString() {
        return "TextComponentImpl{content='" + this.content + "', children=" + String.valueOf(this.children) + ", style=" + String.valueOf(this.style) + "}";
    }

    @Override
    public TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static sealed class BuilderImpl
    extends AbstractComponentBuilder<TextComponent, TextComponent.Builder>
    implements TextComponent.Builder
    permits VirtualComponentImpl.BuilderImpl {
        private String content = "";

        BuilderImpl() {
        }

        BuilderImpl(TextComponent component) {
            super(component);
            this.content = component.content();
        }

        @Override
        public TextComponent.Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            return this;
        }

        @Override
        public String content() {
            return this.content;
        }

        @Override
        public TextComponent build() {
            if (this.isEmpty()) {
                return Component.empty();
            }
            return TextComponentImpl.create(this.children, this.buildStyle(), this.content);
        }

        private boolean isEmpty() {
            return this.content.isEmpty() && this.children.isEmpty() && !this.hasStyle();
        }
    }
}

