/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.PatternReplacementResult;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfigImpl;
import net.kyori.adventure.util.IntFunction2;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public sealed interface TextReplacementConfig
permits TextReplacementConfigImpl {
    public static Builder builder() {
        return new TextReplacementConfigImpl.Builder();
    }

    public Pattern matchPattern();

    @FunctionalInterface
    public static interface Condition {
        public PatternReplacementResult shouldReplace(MatchResult var1, int var2, int var3);
    }

    public static sealed interface Builder
    extends AbstractBuilder<TextReplacementConfig>
    permits TextReplacementConfigImpl.Builder {
        @Contract(value="_ -> this")
        default public Builder matchLiteral(String literal) {
            return this.match(Pattern.compile(literal, 16));
        }

        @Contract(value="_ -> this")
        default public Builder match(@RegExp String pattern) {
            return this.match(Pattern.compile(pattern));
        }

        @Contract(value="_ -> this")
        public Builder match(Pattern var1);

        default public Builder once() {
            return this.times(1);
        }

        @Contract(value="_ -> this")
        default public Builder times(int times) {
            return this.condition((int index, int replaced) -> replaced < times ? PatternReplacementResult.REPLACE : PatternReplacementResult.STOP);
        }

        @Contract(value="_ -> this")
        default public Builder condition(IntFunction2<PatternReplacementResult> condition) {
            return this.condition((MatchResult result, int matchCount, int replaced) -> (PatternReplacementResult)((Object)((Object)condition.apply(matchCount, replaced))));
        }

        @Contract(value="_ -> this")
        public Builder condition(Condition var1);

        @Contract(value="_ -> this")
        default public Builder replacement(String replacement) {
            Objects.requireNonNull(replacement, "replacement");
            return this.replacement((TextComponent.Builder builder) -> builder.content(replacement));
        }

        @Contract(value="_ -> this")
        default public Builder replacement(@Nullable ComponentLike replacement) {
            @Nullable Component baked = ComponentLike.unbox(replacement);
            return this.replacement((MatchResult result, TextComponent.Builder input) -> baked);
        }

        @Contract(value="_ -> this")
        default public Builder replacement(Function<TextComponent.Builder, @Nullable ComponentLike> replacement) {
            Objects.requireNonNull(replacement, "replacement");
            return this.replacement((MatchResult result, TextComponent.Builder input) -> (ComponentLike)replacement.apply((TextComponent.Builder)input));
        }

        @Contract(value="_ -> this")
        public Builder replacement(BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> var1);

        @Contract(value="_ -> this")
        public Builder replaceInsideHoverEvents(boolean var1);
    }
}

