/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.ScopedComponent;
import net.kyori.adventure.text.TranslatableComponentImpl;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.translation.Translatable;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public sealed interface TranslatableComponent
extends ScopedComponent<TranslatableComponent>
permits TranslatableComponentImpl {
    public String key();

    @Contract(pure=true)
    default public TranslatableComponent key(Translatable translatable) {
        return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
    }

    @Contract(pure=true)
    public TranslatableComponent key(String var1);

    public List<TranslationArgument> arguments();

    @Contract(pure=true)
    public TranslatableComponent arguments(ComponentLike ... var1);

    @Contract(pure=true)
    public TranslatableComponent arguments(List<? extends ComponentLike> var1);

    public @Nullable String fallback();

    @Contract(pure=true)
    public TranslatableComponent fallback(@Nullable String var1);

    public Builder toBuilder();

    public static sealed interface Builder
    extends ComponentBuilder<TranslatableComponent, Builder>
    permits TranslatableComponentImpl.BuilderImpl {
        @Contract(pure=true)
        default public Builder key(Translatable translatable) {
            return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
        }

        @Contract(value="_ -> this")
        public Builder key(String var1);

        @Contract(value="_ -> this")
        public Builder arguments(ComponentLike ... var1);

        @Contract(value="_ -> this")
        public Builder arguments(List<? extends ComponentLike> var1);

        @Contract(value="_ -> this")
        public Builder fallback(@Nullable String var1);
    }
}

