/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.TranslationArgumentLike;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

record TranslatableComponentImpl(List<Component> children, Style style, String key, @Nullable String fallback, List<TranslationArgument> args) implements TranslatableComponent
{
    static TranslatableComponent create(List<Component> children, Style style, String key, @Nullable String fallback, ComponentLike[] args) {
        Objects.requireNonNull(args, "args");
        return TranslatableComponentImpl.create(children, style, key, fallback, List.of(args));
    }

    static TranslatableComponent create(List<? extends ComponentLike> children, Style style, String key, @Nullable String fallback, List<? extends ComponentLike> args) {
        return new TranslatableComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(key, "key"), fallback, TranslatableComponentImpl.asArguments(args));
    }

    @Override
    public TranslatableComponent key(String key) {
        if (Objects.equals(this.key, key)) {
            return this;
        }
        return TranslatableComponentImpl.create(this.children, this.style, key, this.fallback, this.args);
    }

    @Override
    public List<TranslationArgument> arguments() {
        return this.args;
    }

    @Override
    public TranslatableComponent arguments(ComponentLike ... args) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, this.fallback, args);
    }

    @Override
    public TranslatableComponent arguments(List<? extends ComponentLike> args) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, this.fallback, args);
    }

    @Override
    public TranslatableComponent fallback(@Nullable String fallback) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, fallback, this.args);
    }

    @Override
    public TranslatableComponent children(List<? extends ComponentLike> children) {
        return TranslatableComponentImpl.create(children, this.style, this.key, this.fallback, this.args);
    }

    @Override
    public TranslatableComponent style(Style style) {
        return TranslatableComponentImpl.create(this.children, style, this.key, this.fallback, this.args);
    }

    @Override
    public TranslatableComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static List<TranslationArgument> asArguments(List<? extends ComponentLike> likes) {
        if (likes.isEmpty()) {
            return List.of();
        }
        ArrayList<TranslationArgument> ret = new ArrayList<TranslationArgument>(likes.size());
        block5: for (int i = 0; i < likes.size(); ++i) {
            ComponentLike like;
            ComponentLike componentLike = like = likes.get(i);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslationArgument.class, TranslationArgumentLike.class}, (Object)componentLike, n)) {
                case -1: {
                    throw new NullPointerException("likes[" + i + "]");
                }
                case 0: {
                    TranslationArgument translationArgument = (TranslationArgument)componentLike;
                    ret.add(translationArgument);
                    continue block5;
                }
                case 1: {
                    TranslationArgumentLike translationArgumentLike = (TranslationArgumentLike)componentLike;
                    ret.add(Objects.requireNonNull(translationArgumentLike.asTranslationArgument(), "likes[" + i + "].asTranslationArgument()"));
                    continue block5;
                }
                default: {
                    ret.add(TranslationArgument.component(like));
                }
            }
        }
        return List.copyOf(ret);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<TranslatableComponent, TranslatableComponent.Builder>
    implements TranslatableComponent.Builder {
        private @Nullable String key;
        private @Nullable String fallback;
        private List<TranslationArgument> args = List.of();

        BuilderImpl() {
        }

        BuilderImpl(TranslatableComponent component) {
            super(component);
            this.key = component.key();
            this.args = component.arguments();
            this.fallback = component.fallback();
        }

        @Override
        public TranslatableComponent.Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public TranslatableComponent.Builder arguments(ComponentLike ... args) {
            Objects.requireNonNull(args, "args");
            if (args.length == 0) {
                return this.arguments(List.of());
            }
            return this.arguments(List.of(args));
        }

        @Override
        public TranslatableComponent.Builder arguments(List<? extends ComponentLike> args) {
            this.args = TranslatableComponentImpl.asArguments(Objects.requireNonNull(args, "args"));
            return this;
        }

        @Override
        public TranslatableComponent.Builder fallback(@Nullable String fallback) {
            this.fallback = fallback;
            return this;
        }

        @Override
        public TranslatableComponent build() {
            if (this.key == null) {
                throw new IllegalStateException("key must be set");
            }
            return TranslatableComponentImpl.create(this.children, this.buildStyle(), this.key, this.fallback, this.args);
        }
    }
}

