/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextComponentImpl;
import net.kyori.adventure.text.VirtualComponent;
import net.kyori.adventure.text.VirtualComponentRenderer;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

final class VirtualComponentImpl<C>
extends TextComponentImpl
implements VirtualComponent {
    private final Class<C> contextType;
    private final VirtualComponentRenderer<C> renderer;

    static <C> VirtualComponent createVirtual(Class<C> contextType, VirtualComponentRenderer<C> renderer) {
        return VirtualComponentImpl.createVirtual(contextType, renderer, List.of(), Style.empty());
    }

    static <C> VirtualComponent createVirtual(Class<C> contextType, VirtualComponentRenderer<C> renderer, List<? extends ComponentLike> children, Style style) {
        List<Component> filteredChildren = ComponentLike.asComponents(children, IS_NOT_EMPTY);
        return new VirtualComponentImpl<C>(filteredChildren, style, "", contextType, renderer);
    }

    private VirtualComponentImpl(List<Component> children, Style style, String content, Class<C> contextType, VirtualComponentRenderer<C> renderer) {
        super(children, style, content);
        this.contextType = contextType;
        this.renderer = renderer;
    }

    @Override
    VirtualComponent create0(List<? extends ComponentLike> children, Style style, String content) {
        return new VirtualComponentImpl<C>(ComponentLike.asComponents(children, IS_NOT_EMPTY), style, content, this.contextType, this.renderer);
    }

    public Class<C> contextType() {
        return this.contextType;
    }

    public VirtualComponentRenderer<C> renderer() {
        return this.renderer;
    }

    @Override
    public String content() {
        return this.renderer.fallbackString();
    }

    @Override
    public TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VirtualComponentImpl)) {
            return false;
        }
        VirtualComponentImpl that = (VirtualComponentImpl)other;
        if (!super.equals(other)) {
            return false;
        }
        return Objects.equals(this.contextType, that.contextType) && Objects.equals(this.renderer, that.renderer);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.contextType.hashCode();
        result = 31 * result + this.renderer.hashCode();
        return result;
    }

    static final class BuilderImpl<C>
    extends TextComponentImpl.BuilderImpl {
        private final Class<C> contextType;
        private final VirtualComponentRenderer<C> renderer;

        BuilderImpl(VirtualComponentImpl<C> other) {
            super(other);
            this.contextType = other.contextType();
            this.renderer = other.renderer();
        }

        @Override
        public TextComponent build() {
            return VirtualComponentImpl.createVirtual(this.contextType, this.renderer, this.children, this.buildStyle());
        }
    }
}

