/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.net.URL;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickCallbackInternals;
import net.kyori.adventure.text.event.ClickCallbackOptionsImpl;
import net.kyori.adventure.text.event.PayloadImpl;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.util.Index;
import org.jspecify.annotations.Nullable;

public final class ClickEvent<T extends Payload>
implements StyleBuilderApplicable {
    private final Action<T> action;
    private final Payload payload;

    public static ClickEvent<Payload.Text> openUrl(String url) {
        return ClickEvent.clickEvent(Action.OPEN_URL, Payload.string(url));
    }

    public static ClickEvent<Payload.Text> openUrl(URL url) {
        return ClickEvent.openUrl(url.toExternalForm());
    }

    public static ClickEvent<Payload.Text> openFile(String file) {
        return ClickEvent.clickEvent(Action.OPEN_FILE, Payload.string(file));
    }

    public static ClickEvent<Payload.Text> runCommand(String command) {
        return ClickEvent.clickEvent(Action.RUN_COMMAND, Payload.string(command));
    }

    public static ClickEvent<Payload.Text> suggestCommand(String command) {
        return ClickEvent.clickEvent(Action.SUGGEST_COMMAND, Payload.string(command));
    }

    public static ClickEvent<Payload.Int> changePage(int page) {
        return ClickEvent.clickEvent(Action.CHANGE_PAGE, Payload.integer(page));
    }

    public static ClickEvent<Payload.Text> copyToClipboard(String text) {
        return ClickEvent.clickEvent(Action.COPY_TO_CLIPBOARD, Payload.string(text));
    }

    public static ClickEvent<?> callback(ClickCallback<Audience> function) {
        return ClickCallbackInternals.PROVIDER.create(Objects.requireNonNull(function, "function"), ClickCallbackOptionsImpl.DEFAULT);
    }

    public static ClickEvent<?> callback(ClickCallback<Audience> function, ClickCallback.Options options) {
        return ClickCallbackInternals.PROVIDER.create(Objects.requireNonNull(function, "function"), Objects.requireNonNull(options, "options"));
    }

    public static ClickEvent<?> callback(ClickCallback<Audience> function, Consumer<ClickCallback.Options.Builder> optionsBuilder) {
        return ClickCallbackInternals.PROVIDER.create(Objects.requireNonNull(function, "function"), (ClickCallback.Options)AbstractBuilder.configureAndBuild(ClickCallback.Options.builder(), Objects.requireNonNull(optionsBuilder, "optionsBuilder")));
    }

    public static ClickEvent<Payload.Dialog> showDialog(DialogLike dialog) {
        return ClickEvent.clickEvent(Action.SHOW_DIALOG, Payload.dialog(dialog));
    }

    public static ClickEvent<Payload.Custom> custom(Key key) {
        return ClickEvent.custom(key, null);
    }

    public static ClickEvent<Payload.Custom> custom(Key key, @Nullable BinaryTagHolder nbt) {
        return ClickEvent.clickEvent(Action.CUSTOM, Payload.custom(key, nbt));
    }

    public static <T extends Payload> ClickEvent<T> clickEvent(Action<T> action, T payload) {
        return new ClickEvent<T>(Objects.requireNonNull(action, "action"), Objects.requireNonNull(payload, "payload"));
    }

    private ClickEvent(Action<T> action, Payload payload) {
        this.action = action;
        this.payload = payload;
    }

    public Action<T> action() {
        return this.action;
    }

    public Payload payload() {
        return this.payload;
    }

    @Override
    public void styleApply(Style.Builder style) {
        style.clickEvent(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClickEvent)) {
            return false;
        }
        ClickEvent that = (ClickEvent)o;
        return this.action.equals(that.action) && this.payload.equals(that.payload);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.payload.hashCode();
        return result;
    }

    public String toString() {
        return "ClickEvent{action=" + String.valueOf(this.action) + ", payload=" + String.valueOf(this.payload) + "}";
    }

    public static abstract sealed class Action<T extends Payload> {
        public static final OpenUrl OPEN_URL = new OpenUrl();
        public static final OpenFile OPEN_FILE = new OpenFile();
        public static final RunCommand RUN_COMMAND = new RunCommand();
        public static final SuggestCommand SUGGEST_COMMAND = new SuggestCommand();
        public static final ChangePage CHANGE_PAGE = new ChangePage();
        public static final CopyToClipboard COPY_TO_CLIPBOARD = new CopyToClipboard();
        public static final ShowDialog SHOW_DIALOG = new ShowDialog();
        public static final Custom CUSTOM = new Custom();
        public static final Index<String, Action<?>> NAMES = Index.create(Action::toString, OPEN_URL, OPEN_FILE, RUN_COMMAND, SUGGEST_COMMAND, CHANGE_PAGE, COPY_TO_CLIPBOARD, SHOW_DIALOG, CUSTOM);
        private final String name;
        private final boolean readable;
        private final Class<? extends Payload> payloadType;

        Action(String name, boolean readable, Class<? extends Payload> payloadType) {
            this.name = name;
            this.readable = readable;
            this.payloadType = payloadType;
        }

        public boolean readable() {
            return this.readable;
        }

        public boolean supports(Payload payload) {
            return this.payloadType.isAssignableFrom(payload.getClass());
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public static final class OpenUrl
        extends TextCarrier {
            private OpenUrl() {
                super("open_url", true);
            }
        }

        public static final class OpenFile
        extends TextCarrier {
            private OpenFile() {
                super("open_file", false);
            }
        }

        public static final class RunCommand
        extends TextCarrier {
            private RunCommand() {
                super("run_command", true);
            }
        }

        public static final class SuggestCommand
        extends TextCarrier {
            private SuggestCommand() {
                super("suggest_command", true);
            }
        }

        public static final class ChangePage
        extends Action<Payload.Int> {
            private ChangePage() {
                super("change_page", true, Payload.Int.class);
            }
        }

        public static final class CopyToClipboard
        extends TextCarrier {
            private CopyToClipboard() {
                super("copy_to_clipboard", true);
            }
        }

        public static final class ShowDialog
        extends Action<Payload.Dialog> {
            private ShowDialog() {
                super("show_dialog", false, Payload.Dialog.class);
            }
        }

        public static final class Custom
        extends Action<Payload.Custom> {
            private Custom() {
                super("custom", true, Payload.Custom.class);
            }
        }

        public static abstract sealed class TextCarrier
        extends Action<Payload.Text>
        permits OpenUrl, OpenFile, RunCommand, SuggestCommand, CopyToClipboard {
            TextCarrier(String name, boolean readable) {
                super(name, readable, Payload.Text.class);
            }
        }
    }

    public static sealed interface Payload {
        public static Text string(String value) {
            Objects.requireNonNull(value, "value");
            return new PayloadImpl.TextImpl(value);
        }

        public static Int integer(int integer) {
            return new PayloadImpl.IntImpl(integer);
        }

        public static Dialog dialog(DialogLike dialog) {
            Objects.requireNonNull(dialog, "dialog");
            return new PayloadImpl.DialogImpl(dialog);
        }

        public static Custom custom(Key key) {
            return Payload.custom(key, null);
        }

        public static Custom custom(Key key, @Nullable BinaryTagHolder nbt) {
            Objects.requireNonNull(key, "key");
            return new PayloadImpl.CustomImpl(key, nbt);
        }

        public static sealed interface Custom
        extends Payload,
        Keyed
        permits PayloadImpl.CustomImpl {
            public @Nullable BinaryTagHolder nbt();
        }

        public static sealed interface Dialog
        extends Payload
        permits PayloadImpl.DialogImpl {
            public DialogLike dialog();
        }

        public static sealed interface Int
        extends Payload
        permits PayloadImpl.IntImpl {
            public int integer();
        }

        public static sealed interface Text
        extends Payload
        permits PayloadImpl.TextImpl {
            public String value();
        }
    }
}

