/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.DataComponentValueConversionImpl;
import net.kyori.adventure.util.PlatformAPI;
import net.kyori.adventure.util.Services;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public final class DataComponentValueConverterRegistry {
    private static final Set<Provider> PROVIDERS = Services.services(Provider.class);

    private DataComponentValueConverterRegistry() {
    }

    public static Set<Key> knownProviders() {
        return PROVIDERS.stream().map(Provider::id).collect(Collectors.toUnmodifiableSet());
    }

    public static <O extends DataComponentValue> O convert(Class<O> target, Key key, DataComponentValue in) {
        if (target.isInstance(in)) {
            return (O)((DataComponentValue)target.cast(in));
        }
        RegisteredConversion converter = ConversionCache.converter(in.getClass(), target);
        if (converter == null) {
            throw new IllegalArgumentException("There is no data holder converter registered to convert from a " + String.valueOf(in.getClass()) + " instance to a " + String.valueOf(target) + " (on field " + String.valueOf(key) + ")");
        }
        try {
            return (O)((DataComponentValue)converter.conversion.convert(key, in));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to convert data component value of type " + String.valueOf(in.getClass()) + " to type " + String.valueOf(target) + " due to an error in a converter provided by " + converter.provider.asString() + "!", ex);
        }
    }

    static final class ConversionCache {
        private static final ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, RegisteredConversion>> CACHE = new ConcurrentHashMap();
        private static final Map<Class<?>, Set<RegisteredConversion>> CONVERSIONS = ConversionCache.collectConversions();

        ConversionCache() {
        }

        private static Map<Class<?>, Set<RegisteredConversion>> collectConversions() {
            ConcurrentHashMap<Class, Set> collected = new ConcurrentHashMap<Class, Set>();
            for (Provider provider : PROVIDERS) {
                Key id = Objects.requireNonNull(provider.id(), () -> "ID of provider " + String.valueOf(provider) + " is null");
                for (Conversion<?, ?> conv : provider.conversions()) {
                    collected.computeIfAbsent(conv.source(), $ -> ConcurrentHashMap.newKeySet()).add(new RegisteredConversion(id, conv));
                }
            }
            for (Map.Entry entry : collected.entrySet()) {
                entry.setValue(Set.copyOf((Collection)entry.getValue()));
            }
            return new ConcurrentHashMap(collected);
        }

        static RegisteredConversion compute(Class<?> src, Class<?> dst) {
            Class sourcePtr;
            ArrayDeque sourceTypes = new ArrayDeque();
            sourceTypes.add(src);
            while ((sourcePtr = (Class)sourceTypes.poll()) != null) {
                Set<RegisteredConversion> conversions = CONVERSIONS.get(sourcePtr);
                if (conversions != null) {
                    RegisteredConversion nearest = null;
                    for (RegisteredConversion potential : conversions) {
                        Class<?> potentialDst = potential.conversion.destination();
                        if (dst.equals(potentialDst)) {
                            return potential;
                        }
                        if (!dst.isAssignableFrom(potentialDst) || nearest != null && !potentialDst.isAssignableFrom(nearest.conversion.destination())) continue;
                        nearest = potential;
                    }
                    if (nearest != null) {
                        return nearest;
                    }
                }
                ConversionCache.addSupertypes(sourcePtr, sourceTypes);
            }
            return RegisteredConversion.NONE;
        }

        private static void addSupertypes(Class<?> clazz, Deque<Class<?>> queue) {
            if (clazz.getSuperclass() != null) {
                queue.add(clazz.getSuperclass());
            }
            queue.addAll(List.of(clazz.getInterfaces()));
        }

        static @Nullable RegisteredConversion converter(Class<? extends DataComponentValue> src, Class<? extends DataComponentValue> dst) {
            RegisteredConversion result = CACHE.computeIfAbsent(src, $ -> new ConcurrentHashMap()).computeIfAbsent(dst, $$ -> ConversionCache.compute(src, dst));
            if (result == RegisteredConversion.NONE) {
                return null;
            }
            return result;
        }
    }

    record RegisteredConversion(@Nullable Key provider, @Nullable Conversion<?, ?> conversion) {
        static final RegisteredConversion NONE = new RegisteredConversion(null, null);
    }

    public static sealed interface Conversion<I, O>
    permits DataComponentValueConversionImpl {
        public static <I1, O1> Conversion<I1, O1> convert(Class<I1> src, Class<O1> dst, BiFunction<Key, I1, O1> op) {
            return new DataComponentValueConversionImpl<I1, O1>(Objects.requireNonNull(src, "src"), Objects.requireNonNull(dst, "dst"), Objects.requireNonNull(op, "op"));
        }

        @Contract(pure=true)
        public Class<I> source();

        @Contract(pure=true)
        public Class<O> destination();

        public O convert(Key var1, I var2);
    }

    @PlatformAPI
    @ApiStatus.NonExtendable
    @ApiStatus.Internal
    public static interface Provider {
        public Key id();

        public Iterable<Conversion<?, ?>> conversions();
    }
}

