/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.renderer.ComponentRenderer;

final class HoverEventRenderers {
    static final ShowText SHOW_TEXT = new ShowText();
    static final ShowItem SHOW_ITEM = new ShowItem();
    static final ShowEntity SHOW_ENTITY = new ShowEntity();
    static final ShowAchievement SHOW_ACHIEVEMENT = new ShowAchievement();

    private HoverEventRenderers() {
    }

    static final class ShowText
    implements HoverEvent.Action.Renderer<Component> {
        private ShowText() {
        }

        @Override
        public <C> Component render(ComponentRenderer<C> renderer, C context, Component value) {
            return renderer.render(value, context);
        }
    }

    static final class ShowItem
    implements HoverEvent.Action.Renderer<HoverEvent.ShowItem> {
        private ShowItem() {
        }

        @Override
        public <C> HoverEvent.ShowItem render(ComponentRenderer<C> renderer, C context, HoverEvent.ShowItem value) {
            return value;
        }
    }

    static final class ShowEntity
    implements HoverEvent.Action.Renderer<HoverEvent.ShowEntity> {
        private ShowEntity() {
        }

        @Override
        public <C> HoverEvent.ShowEntity render(ComponentRenderer<C> renderer, C context, HoverEvent.ShowEntity value) {
            Component name = value.name();
            if (name == null) {
                return value;
            }
            return value.name(renderer.render(name, context));
        }
    }

    static final class ShowAchievement
    implements HoverEvent.Action.Renderer<String> {
        private ShowAchievement() {
        }

        @Override
        public <C> String render(ComponentRenderer<C> renderer, C context, String value) {
            return value;
        }
    }
}

