/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ApiStatus.NonExtendable
public interface MutableStyleSetter<T extends MutableStyleSetter<?>>
extends StyleSetter<T> {
    @Override
    @Contract(value="_ -> this")
    default public T decorate(TextDecoration ... decorations) {
        for (TextDecoration decoration : decorations) {
            this.decorate(decoration);
        }
        return (T)this;
    }

    @Override
    @Contract(value="_ -> this")
    default public T decorations(Map<TextDecoration, TextDecoration.State> decorations) {
        Objects.requireNonNull(decorations, "decorations");
        for (Map.Entry<TextDecoration, TextDecoration.State> entry : decorations.entrySet()) {
            this.decoration(entry.getKey(), entry.getValue());
        }
        return (T)this;
    }

    @Override
    @Contract(value="_, _ -> this")
    default public T decorations(Set<TextDecoration> decorations, boolean flag) {
        TextDecoration.State state = TextDecoration.State.byBoolean(flag);
        decorations.forEach(decoration -> this.decoration((TextDecoration)decoration, state));
        return (T)this;
    }
}

