/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.List;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import net.kyori.adventure.util.Index;
import org.jspecify.annotations.Nullable;

public final class NamedTextColor
implements TextColor {
    static final int BLACK_VALUE = 0;
    static final int DARK_BLUE_VALUE = 170;
    static final int DARK_GREEN_VALUE = 43520;
    static final int DARK_AQUA_VALUE = 43690;
    static final int DARK_RED_VALUE = 0xAA0000;
    static final int DARK_PURPLE_VALUE = 0xAA00AA;
    static final int GOLD_VALUE = 0xFFAA00;
    static final int GRAY_VALUE = 0xAAAAAA;
    static final int DARK_GRAY_VALUE = 0x555555;
    static final int BLUE_VALUE = 0x5555FF;
    static final int GREEN_VALUE = 0x55FF55;
    static final int AQUA_VALUE = 0x55FFFF;
    static final int RED_VALUE = 0xFF5555;
    static final int LIGHT_PURPLE_VALUE = 0xFF55FF;
    static final int YELLOW_VALUE = 0xFFFF55;
    static final int WHITE_VALUE = 0xFFFFFF;
    public static final NamedTextColor BLACK = new NamedTextColor("black", 0);
    public static final NamedTextColor DARK_BLUE = new NamedTextColor("dark_blue", 170);
    public static final NamedTextColor DARK_GREEN = new NamedTextColor("dark_green", 43520);
    public static final NamedTextColor DARK_AQUA = new NamedTextColor("dark_aqua", 43690);
    public static final NamedTextColor DARK_RED = new NamedTextColor("dark_red", 0xAA0000);
    public static final NamedTextColor DARK_PURPLE = new NamedTextColor("dark_purple", 0xAA00AA);
    public static final NamedTextColor GOLD = new NamedTextColor("gold", 0xFFAA00);
    public static final NamedTextColor GRAY = new NamedTextColor("gray", 0xAAAAAA);
    public static final NamedTextColor DARK_GRAY = new NamedTextColor("dark_gray", 0x555555);
    public static final NamedTextColor BLUE = new NamedTextColor("blue", 0x5555FF);
    public static final NamedTextColor GREEN = new NamedTextColor("green", 0x55FF55);
    public static final NamedTextColor AQUA = new NamedTextColor("aqua", 0x55FFFF);
    public static final NamedTextColor RED = new NamedTextColor("red", 0xFF5555);
    public static final NamedTextColor LIGHT_PURPLE = new NamedTextColor("light_purple", 0xFF55FF);
    public static final NamedTextColor YELLOW = new NamedTextColor("yellow", 0xFFFF55);
    public static final NamedTextColor WHITE = new NamedTextColor("white", 0xFFFFFF);
    static final List<NamedTextColor> VALUES = List.of(BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE);
    public static final Index<String, NamedTextColor> NAMES = Index.create(NamedTextColor::name, VALUES);
    private final String name;
    private final int value;
    private final HSVLike hsvLike;

    public static @Nullable NamedTextColor namedColor(int value) {
        return switch (value) {
            case 0 -> BLACK;
            case 170 -> DARK_BLUE;
            case 43520 -> DARK_GREEN;
            case 43690 -> DARK_AQUA;
            case 0xAA0000 -> DARK_RED;
            case 0xAA00AA -> DARK_PURPLE;
            case 0xFFAA00 -> GOLD;
            case 0xAAAAAA -> GRAY;
            case 0x555555 -> DARK_GRAY;
            case 0x5555FF -> BLUE;
            case 0x55FF55 -> GREEN;
            case 0x55FFFF -> AQUA;
            case 0xFF5555 -> RED;
            case 0xFF55FF -> LIGHT_PURPLE;
            case 0xFFFF55 -> YELLOW;
            case 0xFFFFFF -> WHITE;
            default -> null;
        };
    }

    public static NamedTextColor nearestTo(TextColor any) {
        if (any instanceof NamedTextColor) {
            NamedTextColor namedTextColor = (NamedTextColor)any;
            return namedTextColor;
        }
        return TextColor.nearestColorTo(VALUES, any);
    }

    private NamedTextColor(String name, int value) {
        this.name = name;
        this.value = value;
        this.hsvLike = HSVLike.fromRGB(this.red(), this.green(), this.blue());
    }

    public String name() {
        return this.name;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public HSVLike asHSV() {
        return this.hsvLike;
    }

    public String toString() {
        return this.name();
    }
}

