/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ARGBLike;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface StyleSetter<T extends StyleSetter<?>> {
    public T font(@Nullable Key var1);

    public T color(@Nullable TextColor var1);

    public T colorIfAbsent(@Nullable TextColor var1);

    public T shadowColor(@Nullable ARGBLike var1);

    public T shadowColorIfAbsent(@Nullable ARGBLike var1);

    default public T decorate(TextDecoration decoration) {
        return this.decoration(decoration, TextDecoration.State.TRUE);
    }

    default public T decorate(TextDecoration ... decorations) {
        EnumMap<TextDecoration, TextDecoration.State> map = new EnumMap<TextDecoration, TextDecoration.State>(TextDecoration.class);
        for (TextDecoration decoration : decorations) {
            map.put(decoration, TextDecoration.State.TRUE);
        }
        return this.decorations(map);
    }

    default public T decoration(TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    public T decoration(TextDecoration var1, TextDecoration.State var2);

    public T decorationIfAbsent(TextDecoration var1, TextDecoration.State var2);

    public T decorations(Map<TextDecoration, TextDecoration.State> var1);

    default public T decorations(Set<TextDecoration> decorations, boolean flag) {
        return this.decorations(decorations.stream().collect(Collectors.toMap(Function.identity(), decoration -> TextDecoration.State.byBoolean(flag))));
    }

    public T clickEvent(@Nullable ClickEvent<?> var1);

    public T hoverEvent(@Nullable HoverEventSource<?> var1);

    public T insertion(@Nullable String var1);
}

