/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.object;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContentsImpl;
import net.kyori.adventure.text.object.SpriteObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContentsImpl;
import org.jetbrains.annotations.Contract;

public sealed interface ObjectContents
permits SpriteObjectContents, PlayerHeadObjectContents {
    @Contract(value="_, _ -> new", pure=true)
    public static SpriteObjectContents sprite(Key atlas, Key sprite) {
        return new SpriteObjectContentsImpl(Objects.requireNonNull(atlas, "atlas"), Objects.requireNonNull(sprite, "sprite"));
    }

    @Contract(value="_ -> new", pure=true)
    public static SpriteObjectContents sprite(Key sprite) {
        return new SpriteObjectContentsImpl(SpriteObjectContents.DEFAULT_ATLAS, Objects.requireNonNull(sprite, "sprite"));
    }

    @Contract(value="-> new", pure=true)
    public static PlayerHeadObjectContents.Builder playerHead() {
        return new PlayerHeadObjectContentsImpl.BuilderImpl();
    }

    @Contract(value="_ -> new", pure=true)
    public static PlayerHeadObjectContents playerHead(String name) {
        return new PlayerHeadObjectContentsImpl(name, null, List.of(), true, null);
    }

    @Contract(value="_ -> new", pure=true)
    public static PlayerHeadObjectContents playerHead(UUID id) {
        return new PlayerHeadObjectContentsImpl(null, id, List.of(), true, null);
    }

    @Contract(value="_ -> new", pure=true)
    public static PlayerHeadObjectContents playerHead(PlayerHeadObjectContents.SkinSource skinSource) {
        return ObjectContents.playerHead().skin(skinSource).build();
    }
}

