/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.object;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContentsImpl;
import net.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public sealed interface PlayerHeadObjectContents
extends ObjectContents
permits PlayerHeadObjectContentsImpl {
    public static final boolean DEFAULT_HAT = true;

    public @Nullable String name();

    public @Nullable UUID id();

    public @Unmodifiable List<ProfileProperty> profileProperties();

    public boolean hat();

    public @Nullable Key texture();

    @Contract(value="-> new", pure=true)
    public Builder toBuilder();

    @Contract(value="_, _ -> new", pure=true)
    public static ProfileProperty property(String name, String value) {
        return new PlayerHeadObjectContentsImpl.ProfilePropertyImpl(Objects.requireNonNull(name, "name"), Objects.requireNonNull(value, "value"), null);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static ProfileProperty property(String name, String value, @Nullable String signature) {
        return new PlayerHeadObjectContentsImpl.ProfilePropertyImpl(Objects.requireNonNull(name, "name"), Objects.requireNonNull(value, "value"), signature);
    }

    public static interface SkinSource {
        @PlatformAPI
        @ApiStatus.Internal
        public void applySkinToPlayerHeadContents(Builder var1);
    }

    public static sealed interface Builder
    permits PlayerHeadObjectContentsImpl.BuilderImpl {
        @Contract(value="_ -> this")
        public Builder name(@Nullable String var1);

        @Contract(value="_ -> this")
        public Builder id(@Nullable UUID var1);

        @Contract(value="_ -> this")
        public Builder profileProperty(ProfileProperty var1);

        @Contract(value="_ -> this")
        public Builder profileProperties(Collection<? extends ProfileProperty> var1);

        @Contract(value="_ -> this")
        public Builder skin(SkinSource var1);

        @Contract(value="_ -> this")
        public Builder hat(boolean var1);

        @Contract(value="_ -> this")
        public Builder texture(@Nullable Key var1);

        @Contract(value="-> new", pure=true)
        public PlayerHeadObjectContents build();
    }

    public static interface ProfileProperty {
        public String name();

        public String value();

        public @Nullable String signature();
    }
}

