/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.jspecify.annotations.Nullable;

record PlayerHeadObjectContentsImpl(@Nullable String name, @Nullable UUID id, List<PlayerHeadObjectContents.ProfileProperty> profileProperties, boolean hat, @Nullable Key texture) implements PlayerHeadObjectContents
{
    @Override
    public PlayerHeadObjectContents.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements PlayerHeadObjectContents.Builder {
        private @Nullable String name;
        private @Nullable UUID id;
        private final List<PlayerHeadObjectContents.ProfileProperty> properties = new ArrayList<PlayerHeadObjectContents.ProfileProperty>();
        private boolean hat = true;
        private @Nullable Key texture;

        BuilderImpl() {
        }

        BuilderImpl(PlayerHeadObjectContentsImpl playerHeadObjectContents) {
            this.name = playerHeadObjectContents.name;
            this.id = playerHeadObjectContents.id;
            this.properties.addAll(playerHeadObjectContents.profileProperties);
            this.hat = playerHeadObjectContents.hat;
            this.texture = playerHeadObjectContents.texture;
        }

        @Override
        public PlayerHeadObjectContents.Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public PlayerHeadObjectContents.Builder id(@Nullable UUID id) {
            this.id = id;
            return this;
        }

        @Override
        public PlayerHeadObjectContents.Builder profileProperty(PlayerHeadObjectContents.ProfileProperty property) {
            this.properties.add(Objects.requireNonNull(property, "property"));
            return this;
        }

        @Override
        public PlayerHeadObjectContents.Builder profileProperties(Collection<? extends PlayerHeadObjectContents.ProfileProperty> properties) {
            for (PlayerHeadObjectContents.ProfileProperty profileProperty : Objects.requireNonNull(properties, "properties")) {
                this.profileProperty(profileProperty);
            }
            return this;
        }

        private void clearProfile() {
            this.name = null;
            this.id = null;
            this.properties.clear();
            this.texture = null;
        }

        @Override
        public PlayerHeadObjectContents.Builder skin(PlayerHeadObjectContents.SkinSource skinSource) {
            this.clearProfile();
            Objects.requireNonNull(skinSource, "skinSource").applySkinToPlayerHeadContents(this);
            return this;
        }

        @Override
        public PlayerHeadObjectContents.Builder hat(boolean hat) {
            this.hat = hat;
            return this;
        }

        @Override
        public PlayerHeadObjectContents.Builder texture(@Nullable Key texture) {
            this.texture = texture;
            return this;
        }

        @Override
        public PlayerHeadObjectContents build() {
            return new PlayerHeadObjectContentsImpl(this.name, this.id, List.copyOf(this.properties), this.hat, this.texture);
        }
    }

    record ProfilePropertyImpl(String name, String value, @Nullable String signature) implements PlayerHeadObjectContents.ProfileProperty
    {
    }
}

