/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentDecoder;
import net.kyori.adventure.text.serializer.ComponentEncoder;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public interface ComponentSerializer<I extends Component, O extends Component, R>
extends ComponentEncoder<I, R>,
ComponentDecoder<R, O> {
    @Override
    public O deserialize(R var1);

    @Override
    @Contract(value="!null -> !null; null -> null", pure=true)
    default public @Nullable O deserializeOrNull(@Nullable R input) {
        return ComponentDecoder.super.deserializeOr(input, null);
    }

    @Override
    @Contract(value="!null, _ -> !null; null, _ -> param2", pure=true)
    default public @Nullable O deserializeOr(@Nullable R input, @Nullable O fallback) {
        return ComponentDecoder.super.deserializeOr(input, fallback);
    }

    @Override
    public R serialize(I var1);

    @Override
    @Contract(value="!null -> !null; null -> null", pure=true)
    default public @Nullable R serializeOrNull(@Nullable I component) {
        return this.serializeOr(component, null);
    }

    @Override
    @Contract(value="!null, _ -> !null; null, _ -> param2", pure=true)
    default public @Nullable R serializeOr(@Nullable I component, @Nullable R fallback) {
        if (component == null) {
            return fallback;
        }
        return this.serialize(component);
    }
}

