/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.title;

import java.time.Duration;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.UnknownNullability;
import org.jspecify.annotations.Nullable;

record TitleImpl(Component title, Component subtitle, @Nullable Title.Times times) implements Title
{
    TitleImpl(Component title, Component subtitle, @Nullable Title.Times times) {
        this.title = Objects.requireNonNull(title, "title");
        this.subtitle = Objects.requireNonNull(subtitle, "subtitle");
        this.times = times;
    }

    @Override
    public <T> @UnknownNullability T part(TitlePart<T> part) {
        Objects.requireNonNull(part, "part");
        if (part == TitlePart.TITLE) {
            return (T)this.title;
        }
        if (part == TitlePart.SUBTITLE) {
            return (T)this.subtitle;
        }
        if (part == TitlePart.TIMES) {
            return (T)this.times;
        }
        throw new IllegalArgumentException("Don't know what " + String.valueOf(part) + " is.");
    }

    record TimesImpl(Duration fadeIn, Duration stay, Duration fadeOut) implements Title.Times
    {
        TimesImpl(Duration fadeIn, Duration stay, Duration fadeOut) {
            this.fadeIn = Objects.requireNonNull(fadeIn, "fadeIn");
            this.stay = Objects.requireNonNull(stay, "stay");
            this.fadeOut = Objects.requireNonNull(fadeOut, "fadeOut");
        }
    }
}

