/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.translation;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.util.TriState;
import org.jspecify.annotations.Nullable;

public interface Translator {
    public static @Nullable Locale parseLocale(String string) {
        String[] segments = string.split("_", 3);
        int length = segments.length;
        if (length == 1) {
            return Locale.of(string);
        }
        if (length == 2) {
            return Locale.of(segments[0], segments[1]);
        }
        if (length == 3) {
            return Locale.of(segments[0], segments[1], segments[2]);
        }
        return null;
    }

    public Key name();

    default public TriState hasAnyTranslations() {
        return TriState.NOT_SET;
    }

    default public boolean canTranslate(String key, Locale locale) {
        Component translatedValue = this.translate(Component.translatable(Objects.requireNonNull(key, "key")), Objects.requireNonNull(locale, "locale"));
        if (translatedValue != null) {
            return true;
        }
        return this.translate(key, locale) != null;
    }

    public @Nullable MessageFormat translate(String var1, Locale var2);

    default public @Nullable Component translate(TranslatableComponent component, Locale locale) {
        return null;
    }
}

