/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public final class Index<K, V> {
    private final Map<K, V> keyToValue;
    private final Map<V, K> valueToKey;

    public static <K, V extends Enum<V>> Index<K, V> create(Class<V> type, Function<? super V, ? extends K> keyFunction) {
        return Index.create(type, keyFunction, (Enum[])((Enum[])type.getEnumConstants()));
    }

    @SafeVarargs
    public static <K, V extends Enum<V>> Index<K, V> create(Class<V> type, Function<? super V, ? extends K> keyFunction, V ... values) {
        return Index.create(List.of(values), (int length) -> new EnumMap(type), keyFunction);
    }

    @SafeVarargs
    public static <K, V> Index<K, V> create(Function<? super V, ? extends K> keyFunction, V ... values) {
        return Index.create(List.of(values), HashMap::new, keyFunction);
    }

    public static <K, V> Index<K, V> create(Function<? super V, ? extends K> keyFunction, List<V> constants) {
        return Index.create(constants, HashMap::new, keyFunction);
    }

    private static <K, V> Index<K, V> create(List<V> values, IntFunction<Map<V, K>> valueToKeyFactory, Function<? super V, ? extends K> keyFunction) {
        int length = values.size();
        HashMap<K, V> keyToValue = new HashMap<K, V>(length);
        Map<K, V> valueToKey = valueToKeyFactory.apply(length);
        for (int i = 0; i < length; ++i) {
            V value = values.get(i);
            K key = keyFunction.apply(value);
            if (keyToValue.putIfAbsent(key, value) != null) {
                throw new IllegalStateException(String.format("Key %s already mapped to value %s", key, keyToValue.get(key)));
            }
            if (valueToKey.putIfAbsent(value, key) == null) continue;
            throw new IllegalStateException(String.format("Value %s already mapped to key %s", value, valueToKey.get(value)));
        }
        return new Index(Map.copyOf(keyToValue), Map.copyOf(valueToKey));
    }

    private Index(Map<K, V> keyToValue, Map<V, K> valueToKey) {
        this.keyToValue = keyToValue;
        this.valueToKey = valueToKey;
    }

    public Set<K> keys() {
        return Set.copyOf(this.keyToValue.keySet());
    }

    public @Nullable K key(V value) {
        return this.valueToKey.get(value);
    }

    public K keyOrThrow(V value) {
        K key = this.key(value);
        if (key == null) {
            throw new NoSuchElementException("There is no key for value " + String.valueOf(value));
        }
        return key;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public @Nullable K keyOr(V value, @Nullable K defaultKey) {
        K key = this.key(value);
        return key == null ? defaultKey : key;
    }

    public Set<V> values() {
        return Set.copyOf(this.valueToKey.keySet());
    }

    public @Nullable V value(K key) {
        return this.keyToValue.get(key);
    }

    public V valueOrThrow(K key) {
        V value = this.value(key);
        if (value == null) {
            throw new NoSuchElementException("There is no value for key " + String.valueOf(key));
        }
        return value;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public @Nullable V valueOr(K key, @Nullable V defaultValue) {
        V value = this.value(key);
        return value == null ? defaultValue : value;
    }

    public Map<K, V> keyToValue() {
        return Map.copyOf(this.keyToValue);
    }

    public Map<V, K> valueToKey() {
        return Map.copyOf(this.valueToKey);
    }
}

