/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class MonkeyBars {
    private MonkeyBars() {
    }

    @SafeVarargs
    public static <E extends Enum<E>> Set<E> enumSet(Class<E> type, E ... constants) {
        EnumSet<E> set = EnumSet.noneOf(type);
        Collections.addAll(set, constants);
        return Set.copyOf(set);
    }

    public static <T> List<T> addOne(List<T> oldList, T newElement) {
        if (oldList.isEmpty()) {
            return List.of(newElement);
        }
        ArrayList<T> newList = new ArrayList<T>(oldList.size() + 1);
        newList.addAll(oldList);
        newList.add(newElement);
        return List.copyOf(newList);
    }

    @SafeVarargs
    public static <I, O> List<O> nonEmptyArrayToList(Function<I, O> mapper, I first, I ... others) {
        ArrayList<O> ret = new ArrayList<O>(others.length + 1);
        ret.add(mapper.apply(first));
        for (I other : others) {
            ret.add(Objects.requireNonNull(mapper.apply(Objects.requireNonNull(other, "source[?]")), "mapper(source[?])"));
        }
        return List.copyOf(ret);
    }

    public static <I, O> List<O> toUnmodifiableList(Function<I, O> mapper, Iterable<? extends I> source) {
        ArrayList<O> ret = source instanceof Collection ? new ArrayList<O>(((Collection)source).size()) : new ArrayList();
        for (I el : source) {
            ret.add(Objects.requireNonNull(mapper.apply(Objects.requireNonNull(el, "source[?]")), "mapper(source[?])"));
        }
        return List.copyOf(ret);
    }
}

